/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.io;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.http.io.SessionOutputBuffer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ChunkedOutputStream
extends OutputStream
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private SessionOutputBuffer out;
    private byte[] cache;
    private int cachePosition;
    private boolean wroteLastChunk;
    private boolean closed;

    private void $$robo$$org_apache_http_impl_io_ChunkedOutputStream$__constructor__(SessionOutputBuffer out, int bufferSize) throws IOException {
        this.cachePosition = 0;
        this.wroteLastChunk = false;
        this.closed = false;
        this.cache = new byte[bufferSize];
        this.out = out;
    }

    private void $$robo$$org_apache_http_impl_io_ChunkedOutputStream$__constructor__(SessionOutputBuffer out) throws IOException {
    }

    private final void $$robo$$org_apache_http_impl_io_ChunkedOutputStream$flushCache() throws IOException {
        if (this.cachePosition > 0) {
            this.out.writeLine(Integer.toHexString(this.cachePosition));
            this.out.write(this.cache, 0, this.cachePosition);
            this.out.writeLine("");
            this.cachePosition = 0;
        }
    }

    private final void $$robo$$org_apache_http_impl_io_ChunkedOutputStream$flushCacheWithAppend(byte[] bufferToAppend, int off, int len) throws IOException {
        this.out.writeLine(Integer.toHexString(this.cachePosition + len));
        this.out.write(this.cache, 0, this.cachePosition);
        this.out.write(bufferToAppend, off, len);
        this.out.writeLine("");
        this.cachePosition = 0;
    }

    private final void $$robo$$org_apache_http_impl_io_ChunkedOutputStream$writeClosingChunk() throws IOException {
        this.out.writeLine("0");
        this.out.writeLine("");
    }

    private final void $$robo$$org_apache_http_impl_io_ChunkedOutputStream$finish() throws IOException {
        if (!this.wroteLastChunk) {
            this.flushCache();
            this.writeClosingChunk();
            this.wroteLastChunk = true;
        }
    }

    private final void $$robo$$org_apache_http_impl_io_ChunkedOutputStream$write(int b) throws IOException {
        if (this.closed) {
            throw new IOException("Attempted write to closed stream.");
        }
        this.cache[this.cachePosition] = (byte)b;
        ++this.cachePosition;
        if (this.cachePosition == this.cache.length) {
            this.flushCache();
        }
    }

    private final void $$robo$$org_apache_http_impl_io_ChunkedOutputStream$write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    private final void $$robo$$org_apache_http_impl_io_ChunkedOutputStream$write(byte[] src, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Attempted write to closed stream.");
        }
        if (len >= this.cache.length - this.cachePosition) {
            this.flushCacheWithAppend(src, off, len);
        } else {
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])src, (int)off, (byte[])this.cache, (int)this.cachePosition, (int)len);
            this.cachePosition += len;
        }
    }

    private final void $$robo$$org_apache_http_impl_io_ChunkedOutputStream$flush() throws IOException {
        this.flushCache();
        this.out.flush();
    }

    private final void $$robo$$org_apache_http_impl_io_ChunkedOutputStream$close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.finish();
            this.out.flush();
        }
    }

    private void __constructor__(SessionOutputBuffer sessionOutputBuffer, int n) throws IOException {
        this.$$robo$$org_apache_http_impl_io_ChunkedOutputStream$__constructor__(sessionOutputBuffer, n);
    }

    public ChunkedOutputStream(SessionOutputBuffer sessionOutputBuffer, int n) throws IOException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_io_ChunkedOutputStream$__constructor__(org.apache.http.io.SessionOutputBuffer int ), 0, this, sessionOutputBuffer, n);
    }

    private void __constructor__(SessionOutputBuffer sessionOutputBuffer) throws IOException {
        this.$$robo$$org_apache_http_impl_io_ChunkedOutputStream$__constructor__(sessionOutputBuffer);
    }

    public ChunkedOutputStream(SessionOutputBuffer sessionOutputBuffer) throws IOException {
        this(sessionOutputBuffer, 2048);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_io_ChunkedOutputStream$__constructor__(org.apache.http.io.SessionOutputBuffer ), 0, this, sessionOutputBuffer);
    }

    protected void flushCache() throws IOException {
        InvokeDynamicSupport.bootstrap("flushCache", $$robo$$org_apache_http_impl_io_ChunkedOutputStream$flushCache(), 0, this);
    }

    protected void flushCacheWithAppend(byte[] byArray, int n, int n2) throws IOException {
        InvokeDynamicSupport.bootstrap("flushCacheWithAppend", $$robo$$org_apache_http_impl_io_ChunkedOutputStream$flushCacheWithAppend(byte[] int int ), 0, this, byArray, n, n2);
    }

    protected void writeClosingChunk() throws IOException {
        InvokeDynamicSupport.bootstrap("writeClosingChunk", $$robo$$org_apache_http_impl_io_ChunkedOutputStream$writeClosingChunk(), 0, this);
    }

    public void finish() throws IOException {
        InvokeDynamicSupport.bootstrap("finish", $$robo$$org_apache_http_impl_io_ChunkedOutputStream$finish(), 0, this);
    }

    @Override
    public void write(int n) throws IOException {
        InvokeDynamicSupport.bootstrap("write", $$robo$$org_apache_http_impl_io_ChunkedOutputStream$write(int ), 0, this, n);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        InvokeDynamicSupport.bootstrap("write", $$robo$$org_apache_http_impl_io_ChunkedOutputStream$write(byte[] ), 0, this, byArray);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        InvokeDynamicSupport.bootstrap("write", $$robo$$org_apache_http_impl_io_ChunkedOutputStream$write(byte[] int int ), 0, this, byArray, n, n2);
    }

    @Override
    public void flush() throws IOException {
        InvokeDynamicSupport.bootstrap("flush", $$robo$$org_apache_http_impl_io_ChunkedOutputStream$flush(), 0, this);
    }

    @Override
    public void close() throws IOException {
        InvokeDynamicSupport.bootstrap("close", $$robo$$org_apache_http_impl_io_ChunkedOutputStream$close(), 0, this);
    }

    public /* synthetic */ ChunkedOutputStream() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ChunkedOutputStream)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

