/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.io.SessionInputBuffer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ContentLengthInputStream
extends InputStream
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int BUFFER_SIZE = 2048;
    private long contentLength;
    private long pos;
    private boolean closed;
    private SessionInputBuffer in;

    private void $$robo$$org_apache_http_impl_io_ContentLengthInputStream$__constructor__(SessionInputBuffer in, long contentLength) {
        this.pos = 0L;
        this.closed = false;
        this.in = null;
        if (in == null) {
            throw new IllegalArgumentException("Input stream may not be null");
        }
        if (contentLength < 0L) {
            throw new IllegalArgumentException("Content length may not be negative");
        }
        this.in = in;
        this.contentLength = contentLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$org_apache_http_impl_io_ContentLengthInputStream$close() throws IOException {
        if (!this.closed) {
            try {
                byte[] buffer = new byte[2048];
                while (this.read(buffer) >= 0) {
                }
            }
            finally {
                this.closed = true;
            }
        }
    }

    private final int $$robo$$org_apache_http_impl_io_ContentLengthInputStream$read() throws IOException {
        if (this.closed) {
            throw new IOException("Attempted read from closed stream.");
        }
        if (this.pos >= this.contentLength) {
            return -1;
        }
        ++this.pos;
        return this.in.read();
    }

    private final int $$robo$$org_apache_http_impl_io_ContentLengthInputStream$read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Attempted read from closed stream.");
        }
        if (this.pos >= this.contentLength) {
            return -1;
        }
        if (this.pos + (long)len > this.contentLength) {
            len = (int)(this.contentLength - this.pos);
        }
        int count = this.in.read(b, off, len);
        this.pos += (long)count;
        return count;
    }

    private final int $$robo$$org_apache_http_impl_io_ContentLengthInputStream$read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    private final long $$robo$$org_apache_http_impl_io_ContentLengthInputStream$skip(long n) throws IOException {
        int l;
        if (n <= 0L) {
            return 0L;
        }
        byte[] buffer = new byte[2048];
        long count = 0L;
        for (long remaining = Math.min(n, this.contentLength - this.pos); remaining > 0L && (l = this.read(buffer, 0, (int)Math.min(2048L, remaining))) != -1; remaining -= (long)l) {
            count += (long)l;
        }
        this.pos += count;
        return count;
    }

    private void __constructor__(SessionInputBuffer sessionInputBuffer, long l) {
        this.$$robo$$org_apache_http_impl_io_ContentLengthInputStream$__constructor__(sessionInputBuffer, l);
    }

    public ContentLengthInputStream(SessionInputBuffer sessionInputBuffer, long l) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_io_ContentLengthInputStream$__constructor__(org.apache.http.io.SessionInputBuffer long ), 0, this, sessionInputBuffer, l);
    }

    @Override
    public void close() throws IOException {
        InvokeDynamicSupport.bootstrap("close", $$robo$$org_apache_http_impl_io_ContentLengthInputStream$close(), 0, this);
    }

    @Override
    public int read() throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$org_apache_http_impl_io_ContentLengthInputStream$read(), 0, this);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$org_apache_http_impl_io_ContentLengthInputStream$read(byte[] int int ), 0, this, byArray, n, n2);
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$org_apache_http_impl_io_ContentLengthInputStream$read(byte[] ), 0, this, byArray);
    }

    @Override
    public long skip(long l) throws IOException {
        return (long)InvokeDynamicSupport.bootstrap("skip", $$robo$$org_apache_http_impl_io_ContentLengthInputStream$skip(long ), 0, this, l);
    }

    public /* synthetic */ ContentLengthInputStream() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ContentLengthInputStream)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

