/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.io;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.http.io.SessionOutputBuffer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ContentLengthOutputStream
extends OutputStream
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private SessionOutputBuffer out;
    private long contentLength;
    private long total;
    private boolean closed;

    private void $$robo$$org_apache_http_impl_io_ContentLengthOutputStream$__constructor__(SessionOutputBuffer out, long contentLength) {
        this.total = 0L;
        this.closed = false;
        if (out == null) {
            throw new IllegalArgumentException("Session output buffer may not be null");
        }
        if (contentLength < 0L) {
            throw new IllegalArgumentException("Content length may not be negative");
        }
        this.out = out;
        this.contentLength = contentLength;
    }

    private final void $$robo$$org_apache_http_impl_io_ContentLengthOutputStream$close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.out.flush();
        }
    }

    private final void $$robo$$org_apache_http_impl_io_ContentLengthOutputStream$flush() throws IOException {
        this.out.flush();
    }

    private final void $$robo$$org_apache_http_impl_io_ContentLengthOutputStream$write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Attempted write to closed stream.");
        }
        if (this.total < this.contentLength) {
            long max = this.contentLength - this.total;
            if ((long)len > max) {
                len = (int)max;
            }
            this.out.write(b, off, len);
            this.total += (long)len;
        }
    }

    private final void $$robo$$org_apache_http_impl_io_ContentLengthOutputStream$write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    private final void $$robo$$org_apache_http_impl_io_ContentLengthOutputStream$write(int b) throws IOException {
        if (this.closed) {
            throw new IOException("Attempted write to closed stream.");
        }
        if (this.total < this.contentLength) {
            this.out.write(b);
            ++this.total;
        }
    }

    private void __constructor__(SessionOutputBuffer sessionOutputBuffer, long l) {
        this.$$robo$$org_apache_http_impl_io_ContentLengthOutputStream$__constructor__(sessionOutputBuffer, l);
    }

    public ContentLengthOutputStream(SessionOutputBuffer sessionOutputBuffer, long l) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_io_ContentLengthOutputStream$__constructor__(org.apache.http.io.SessionOutputBuffer long ), 0, this, sessionOutputBuffer, l);
    }

    @Override
    public void close() throws IOException {
        InvokeDynamicSupport.bootstrap("close", $$robo$$org_apache_http_impl_io_ContentLengthOutputStream$close(), 0, this);
    }

    @Override
    public void flush() throws IOException {
        InvokeDynamicSupport.bootstrap("flush", $$robo$$org_apache_http_impl_io_ContentLengthOutputStream$flush(), 0, this);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        InvokeDynamicSupport.bootstrap("write", $$robo$$org_apache_http_impl_io_ContentLengthOutputStream$write(byte[] int int ), 0, this, byArray, n, n2);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        InvokeDynamicSupport.bootstrap("write", $$robo$$org_apache_http_impl_io_ContentLengthOutputStream$write(byte[] ), 0, this, byArray);
    }

    @Override
    public void write(int n) throws IOException {
        InvokeDynamicSupport.bootstrap("write", $$robo$$org_apache_http_impl_io_ContentLengthOutputStream$write(int ), 0, this, n);
    }

    public /* synthetic */ ContentLengthOutputStream() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ContentLengthOutputStream)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

