/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.message.HeaderValueFormatter;
import org.apache.http.util.CharArrayBuffer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class BasicHeaderValueFormatter
implements HeaderValueFormatter,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static BasicHeaderValueFormatter DEFAULT;
    public static String SEPARATORS = " ;,:@()<>\\\"/[]?={}\t";
    public static String UNSAFE_CHARS = "\"\\";

    private void $$robo$$org_apache_http_message_BasicHeaderValueFormatter$__constructor__() {
    }

    private static final String $$robo$$org_apache_http_message_BasicHeaderValueFormatter$formatElements(HeaderElement[] elems, boolean quote, HeaderValueFormatter formatter) {
        if (formatter == null) {
            formatter = DEFAULT;
        }
        return formatter.formatElements(null, elems, quote).toString();
    }

    private final CharArrayBuffer $$robo$$org_apache_http_message_BasicHeaderValueFormatter$formatElements(CharArrayBuffer buffer, HeaderElement[] elems, boolean quote) {
        if (elems == null) {
            throw new IllegalArgumentException("Header element array must not be null.");
        }
        int len = this.estimateElementsLen(elems);
        if (buffer == null) {
            buffer = new CharArrayBuffer(len);
        } else {
            buffer.ensureCapacity(len);
        }
        for (int i = 0; i < elems.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            this.formatHeaderElement(buffer, elems[i], quote);
        }
        return buffer;
    }

    private final int $$robo$$org_apache_http_message_BasicHeaderValueFormatter$estimateElementsLen(HeaderElement[] elems) {
        if (elems == null || elems.length < 1) {
            return 0;
        }
        int result = (elems.length - 1) * 2;
        for (int i = 0; i < elems.length; ++i) {
            result += this.estimateHeaderElementLen(elems[i]);
        }
        return result;
    }

    private static final String $$robo$$org_apache_http_message_BasicHeaderValueFormatter$formatHeaderElement(HeaderElement elem, boolean quote, HeaderValueFormatter formatter) {
        if (formatter == null) {
            formatter = DEFAULT;
        }
        return formatter.formatHeaderElement(null, elem, quote).toString();
    }

    private final CharArrayBuffer $$robo$$org_apache_http_message_BasicHeaderValueFormatter$formatHeaderElement(CharArrayBuffer buffer, HeaderElement elem, boolean quote) {
        int parcnt;
        if (elem == null) {
            throw new IllegalArgumentException("Header element must not be null.");
        }
        int len = this.estimateHeaderElementLen(elem);
        if (buffer == null) {
            buffer = new CharArrayBuffer(len);
        } else {
            buffer.ensureCapacity(len);
        }
        buffer.append(elem.getName());
        String value = elem.getValue();
        if (value != null) {
            buffer.append('=');
            this.doFormatValue(buffer, value, quote);
        }
        if ((parcnt = elem.getParameterCount()) > 0) {
            for (int i = 0; i < parcnt; ++i) {
                buffer.append("; ");
                this.formatNameValuePair(buffer, elem.getParameter(i), quote);
            }
        }
        return buffer;
    }

    private final int $$robo$$org_apache_http_message_BasicHeaderValueFormatter$estimateHeaderElementLen(HeaderElement elem) {
        int parcnt;
        if (elem == null) {
            return 0;
        }
        int result = elem.getName().length();
        String value = elem.getValue();
        if (value != null) {
            result += 3 + value.length();
        }
        if ((parcnt = elem.getParameterCount()) > 0) {
            for (int i = 0; i < parcnt; ++i) {
                result += 2 + this.estimateNameValuePairLen(elem.getParameter(i));
            }
        }
        return result;
    }

    private static final String $$robo$$org_apache_http_message_BasicHeaderValueFormatter$formatParameters(NameValuePair[] nvps, boolean quote, HeaderValueFormatter formatter) {
        if (formatter == null) {
            formatter = DEFAULT;
        }
        return formatter.formatParameters(null, nvps, quote).toString();
    }

    private final CharArrayBuffer $$robo$$org_apache_http_message_BasicHeaderValueFormatter$formatParameters(CharArrayBuffer buffer, NameValuePair[] nvps, boolean quote) {
        if (nvps == null) {
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        int len = this.estimateParametersLen(nvps);
        if (buffer == null) {
            buffer = new CharArrayBuffer(len);
        } else {
            buffer.ensureCapacity(len);
        }
        for (int i = 0; i < nvps.length; ++i) {
            if (i > 0) {
                buffer.append("; ");
            }
            this.formatNameValuePair(buffer, nvps[i], quote);
        }
        return buffer;
    }

    private final int $$robo$$org_apache_http_message_BasicHeaderValueFormatter$estimateParametersLen(NameValuePair[] nvps) {
        if (nvps == null || nvps.length < 1) {
            return 0;
        }
        int result = (nvps.length - 1) * 2;
        for (int i = 0; i < nvps.length; ++i) {
            result += this.estimateNameValuePairLen(nvps[i]);
        }
        return result;
    }

    private static final String $$robo$$org_apache_http_message_BasicHeaderValueFormatter$formatNameValuePair(NameValuePair nvp, boolean quote, HeaderValueFormatter formatter) {
        if (formatter == null) {
            formatter = DEFAULT;
        }
        return formatter.formatNameValuePair(null, nvp, quote).toString();
    }

    private final CharArrayBuffer $$robo$$org_apache_http_message_BasicHeaderValueFormatter$formatNameValuePair(CharArrayBuffer buffer, NameValuePair nvp, boolean quote) {
        if (nvp == null) {
            throw new IllegalArgumentException("NameValuePair must not be null.");
        }
        int len = this.estimateNameValuePairLen(nvp);
        if (buffer == null) {
            buffer = new CharArrayBuffer(len);
        } else {
            buffer.ensureCapacity(len);
        }
        buffer.append(nvp.getName());
        String value = nvp.getValue();
        if (value != null) {
            buffer.append('=');
            this.doFormatValue(buffer, value, quote);
        }
        return buffer;
    }

    private final int $$robo$$org_apache_http_message_BasicHeaderValueFormatter$estimateNameValuePairLen(NameValuePair nvp) {
        if (nvp == null) {
            return 0;
        }
        int result = nvp.getName().length();
        String value = nvp.getValue();
        if (value != null) {
            result += 3 + value.length();
        }
        return result;
    }

    private final void $$robo$$org_apache_http_message_BasicHeaderValueFormatter$doFormatValue(CharArrayBuffer buffer, String value, boolean quote) {
        int i;
        if (!quote) {
            for (i = 0; i < value.length() && !quote; ++i) {
                quote = this.isSeparator(value.charAt(i));
            }
        }
        if (quote) {
            buffer.append('\"');
        }
        for (i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (this.isUnsafe(ch)) {
                buffer.append('\\');
            }
            buffer.append(ch);
        }
        if (quote) {
            buffer.append('\"');
        }
    }

    private final boolean $$robo$$org_apache_http_message_BasicHeaderValueFormatter$isSeparator(char ch) {
        return " ;,:@()<>\\\"/[]?={}\t".indexOf(ch) >= 0;
    }

    private final boolean $$robo$$org_apache_http_message_BasicHeaderValueFormatter$isUnsafe(char ch) {
        return "\"\\".indexOf(ch) >= 0;
    }

    static void __staticInitializer__() {
        DEFAULT = new BasicHeaderValueFormatter();
    }

    private void __constructor__() {
        this.$$robo$$org_apache_http_message_BasicHeaderValueFormatter$__constructor__();
    }

    public BasicHeaderValueFormatter() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_message_BasicHeaderValueFormatter$__constructor__(), 0, this);
    }

    public static String formatElements(HeaderElement[] headerElementArray, boolean bl, HeaderValueFormatter headerValueFormatter) {
        return InvokeDynamicSupport.bootstrapStatic("formatElements", $$robo$$org_apache_http_message_BasicHeaderValueFormatter$formatElements(org.apache.http.HeaderElement[] boolean org.apache.http.message.HeaderValueFormatter ), 0, (HeaderElement[])headerElementArray, (boolean)bl, (HeaderValueFormatter)headerValueFormatter);
    }

    @Override
    public CharArrayBuffer formatElements(CharArrayBuffer charArrayBuffer, HeaderElement[] headerElementArray, boolean bl) {
        return InvokeDynamicSupport.bootstrap("formatElements", $$robo$$org_apache_http_message_BasicHeaderValueFormatter$formatElements(org.apache.http.util.CharArrayBuffer org.apache.http.HeaderElement[] boolean ), 0, this, charArrayBuffer, headerElementArray, bl);
    }

    protected int estimateElementsLen(HeaderElement[] headerElementArray) {
        return (int)InvokeDynamicSupport.bootstrap("estimateElementsLen", $$robo$$org_apache_http_message_BasicHeaderValueFormatter$estimateElementsLen(org.apache.http.HeaderElement[] ), 0, this, headerElementArray);
    }

    public static String formatHeaderElement(HeaderElement headerElement, boolean bl, HeaderValueFormatter headerValueFormatter) {
        return InvokeDynamicSupport.bootstrapStatic("formatHeaderElement", $$robo$$org_apache_http_message_BasicHeaderValueFormatter$formatHeaderElement(org.apache.http.HeaderElement boolean org.apache.http.message.HeaderValueFormatter ), 0, (HeaderElement)headerElement, (boolean)bl, (HeaderValueFormatter)headerValueFormatter);
    }

    @Override
    public CharArrayBuffer formatHeaderElement(CharArrayBuffer charArrayBuffer, HeaderElement headerElement, boolean bl) {
        return InvokeDynamicSupport.bootstrap("formatHeaderElement", $$robo$$org_apache_http_message_BasicHeaderValueFormatter$formatHeaderElement(org.apache.http.util.CharArrayBuffer org.apache.http.HeaderElement boolean ), 0, this, charArrayBuffer, headerElement, bl);
    }

    protected int estimateHeaderElementLen(HeaderElement headerElement) {
        return (int)InvokeDynamicSupport.bootstrap("estimateHeaderElementLen", $$robo$$org_apache_http_message_BasicHeaderValueFormatter$estimateHeaderElementLen(org.apache.http.HeaderElement ), 0, this, headerElement);
    }

    public static String formatParameters(NameValuePair[] nameValuePairArray, boolean bl, HeaderValueFormatter headerValueFormatter) {
        return InvokeDynamicSupport.bootstrapStatic("formatParameters", $$robo$$org_apache_http_message_BasicHeaderValueFormatter$formatParameters(org.apache.http.NameValuePair[] boolean org.apache.http.message.HeaderValueFormatter ), 0, (NameValuePair[])nameValuePairArray, (boolean)bl, (HeaderValueFormatter)headerValueFormatter);
    }

    @Override
    public CharArrayBuffer formatParameters(CharArrayBuffer charArrayBuffer, NameValuePair[] nameValuePairArray, boolean bl) {
        return InvokeDynamicSupport.bootstrap("formatParameters", $$robo$$org_apache_http_message_BasicHeaderValueFormatter$formatParameters(org.apache.http.util.CharArrayBuffer org.apache.http.NameValuePair[] boolean ), 0, this, charArrayBuffer, nameValuePairArray, bl);
    }

    protected int estimateParametersLen(NameValuePair[] nameValuePairArray) {
        return (int)InvokeDynamicSupport.bootstrap("estimateParametersLen", $$robo$$org_apache_http_message_BasicHeaderValueFormatter$estimateParametersLen(org.apache.http.NameValuePair[] ), 0, this, nameValuePairArray);
    }

    public static String formatNameValuePair(NameValuePair nameValuePair, boolean bl, HeaderValueFormatter headerValueFormatter) {
        return InvokeDynamicSupport.bootstrapStatic("formatNameValuePair", $$robo$$org_apache_http_message_BasicHeaderValueFormatter$formatNameValuePair(org.apache.http.NameValuePair boolean org.apache.http.message.HeaderValueFormatter ), 0, (NameValuePair)nameValuePair, (boolean)bl, (HeaderValueFormatter)headerValueFormatter);
    }

    @Override
    public CharArrayBuffer formatNameValuePair(CharArrayBuffer charArrayBuffer, NameValuePair nameValuePair, boolean bl) {
        return InvokeDynamicSupport.bootstrap("formatNameValuePair", $$robo$$org_apache_http_message_BasicHeaderValueFormatter$formatNameValuePair(org.apache.http.util.CharArrayBuffer org.apache.http.NameValuePair boolean ), 0, this, charArrayBuffer, nameValuePair, bl);
    }

    protected int estimateNameValuePairLen(NameValuePair nameValuePair) {
        return (int)InvokeDynamicSupport.bootstrap("estimateNameValuePairLen", $$robo$$org_apache_http_message_BasicHeaderValueFormatter$estimateNameValuePairLen(org.apache.http.NameValuePair ), 0, this, nameValuePair);
    }

    protected void doFormatValue(CharArrayBuffer charArrayBuffer, String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("doFormatValue", $$robo$$org_apache_http_message_BasicHeaderValueFormatter$doFormatValue(org.apache.http.util.CharArrayBuffer java.lang.String boolean ), 0, this, charArrayBuffer, string2, bl);
    }

    protected boolean isSeparator(char c) {
        return (boolean)InvokeDynamicSupport.bootstrap("isSeparator", $$robo$$org_apache_http_message_BasicHeaderValueFormatter$isSeparator(char ), 0, this, c);
    }

    protected boolean isUnsafe(char c) {
        return (boolean)InvokeDynamicSupport.bootstrap("isUnsafe", $$robo$$org_apache_http_message_BasicHeaderValueFormatter$isUnsafe(char ), 0, this, c);
    }

    static {
        RobolectricInternals.classInitializing(BasicHeaderValueFormatter.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BasicHeaderValueFormatter)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

