/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import java.util.ArrayList;
import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.ParseException;
import org.apache.http.message.BasicHeaderElement;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.message.HeaderValueParser;
import org.apache.http.message.ParserCursor;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.CharArrayBuffer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class BasicHeaderValueParser
implements HeaderValueParser,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static BasicHeaderValueParser DEFAULT;
    private static char PARAM_DELIMITER = ';';
    private static char ELEM_DELIMITER = ',';
    private static char[] ALL_DELIMITERS;

    private void $$robo$$org_apache_http_message_BasicHeaderValueParser$__constructor__() {
    }

    private static final HeaderElement[] $$robo$$org_apache_http_message_BasicHeaderValueParser$parseElements(String value, HeaderValueParser parser) throws ParseException {
        if (value == null) {
            throw new IllegalArgumentException("Value to parse may not be null");
        }
        if (parser == null) {
            parser = DEFAULT;
        }
        CharArrayBuffer buffer = new CharArrayBuffer(value.length());
        buffer.append(value);
        ParserCursor cursor = new ParserCursor(0, value.length());
        return parser.parseElements(buffer, cursor);
    }

    private final HeaderElement[] $$robo$$org_apache_http_message_BasicHeaderValueParser$parseElements(CharArrayBuffer buffer, ParserCursor cursor) {
        if (buffer == null) {
            throw new IllegalArgumentException("Char array buffer may not be null");
        }
        if (cursor == null) {
            throw new IllegalArgumentException("Parser cursor may not be null");
        }
        ArrayList<HeaderElement> elements = new ArrayList<HeaderElement>();
        while (!cursor.atEnd()) {
            HeaderElement element = this.parseHeaderElement(buffer, cursor);
            if (element.getName().length() == 0 && element.getValue() == null) continue;
            elements.add(element);
        }
        return elements.toArray(new HeaderElement[elements.size()]);
    }

    private static final HeaderElement $$robo$$org_apache_http_message_BasicHeaderValueParser$parseHeaderElement(String value, HeaderValueParser parser) throws ParseException {
        if (value == null) {
            throw new IllegalArgumentException("Value to parse may not be null");
        }
        if (parser == null) {
            parser = DEFAULT;
        }
        CharArrayBuffer buffer = new CharArrayBuffer(value.length());
        buffer.append(value);
        ParserCursor cursor = new ParserCursor(0, value.length());
        return parser.parseHeaderElement(buffer, cursor);
    }

    private final HeaderElement $$robo$$org_apache_http_message_BasicHeaderValueParser$parseHeaderElement(CharArrayBuffer buffer, ParserCursor cursor) {
        char ch;
        if (buffer == null) {
            throw new IllegalArgumentException("Char array buffer may not be null");
        }
        if (cursor == null) {
            throw new IllegalArgumentException("Parser cursor may not be null");
        }
        NameValuePair nvp = this.parseNameValuePair(buffer, cursor);
        NameValuePair[] params = null;
        if (!cursor.atEnd() && (ch = buffer.charAt(cursor.getPos() - 1)) != ',') {
            params = this.parseParameters(buffer, cursor);
        }
        return this.createHeaderElement(nvp.getName(), nvp.getValue(), params);
    }

    private final HeaderElement $$robo$$org_apache_http_message_BasicHeaderValueParser$createHeaderElement(String name, String value, NameValuePair[] params) {
        return new BasicHeaderElement(name, value, params);
    }

    private static final NameValuePair[] $$robo$$org_apache_http_message_BasicHeaderValueParser$parseParameters(String value, HeaderValueParser parser) throws ParseException {
        if (value == null) {
            throw new IllegalArgumentException("Value to parse may not be null");
        }
        if (parser == null) {
            parser = DEFAULT;
        }
        CharArrayBuffer buffer = new CharArrayBuffer(value.length());
        buffer.append(value);
        ParserCursor cursor = new ParserCursor(0, value.length());
        return parser.parseParameters(buffer, cursor);
    }

    private final NameValuePair[] $$robo$$org_apache_http_message_BasicHeaderValueParser$parseParameters(CharArrayBuffer buffer, ParserCursor cursor) {
        char ch;
        int pos;
        if (buffer == null) {
            throw new IllegalArgumentException("Char array buffer may not be null");
        }
        if (cursor == null) {
            throw new IllegalArgumentException("Parser cursor may not be null");
        }
        int indexTo = cursor.getUpperBound();
        for (pos = cursor.getPos(); pos < indexTo && HTTP.isWhitespace(ch = buffer.charAt(pos)); ++pos) {
        }
        cursor.updatePos(pos);
        if (cursor.atEnd()) {
            return new NameValuePair[0];
        }
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        while (!cursor.atEnd()) {
            NameValuePair param = this.parseNameValuePair(buffer, cursor);
            params.add(param);
            char ch2 = buffer.charAt(cursor.getPos() - 1);
            if (ch2 != ',') continue;
            break;
        }
        return params.toArray(new NameValuePair[params.size()]);
    }

    private static final NameValuePair $$robo$$org_apache_http_message_BasicHeaderValueParser$parseNameValuePair(String value, HeaderValueParser parser) throws ParseException {
        if (value == null) {
            throw new IllegalArgumentException("Value to parse may not be null");
        }
        if (parser == null) {
            parser = DEFAULT;
        }
        CharArrayBuffer buffer = new CharArrayBuffer(value.length());
        buffer.append(value);
        ParserCursor cursor = new ParserCursor(0, value.length());
        return parser.parseNameValuePair(buffer, cursor);
    }

    private final NameValuePair $$robo$$org_apache_http_message_BasicHeaderValueParser$parseNameValuePair(CharArrayBuffer buffer, ParserCursor cursor) {
        return this.parseNameValuePair(buffer, cursor, ALL_DELIMITERS);
    }

    private static final boolean $$robo$$org_apache_http_message_BasicHeaderValueParser$isOneOf(char ch, char[] chs) {
        if (chs != null) {
            for (int i = 0; i < chs.length; ++i) {
                if (ch != chs[i]) continue;
                return true;
            }
        }
        return false;
    }

    private final NameValuePair $$robo$$org_apache_http_message_BasicHeaderValueParser$parseNameValuePair(CharArrayBuffer buffer, ParserCursor cursor, char[] delimiters) {
        char ch;
        int pos;
        if (buffer == null) {
            throw new IllegalArgumentException("Char array buffer may not be null");
        }
        if (cursor == null) {
            throw new IllegalArgumentException("Parser cursor may not be null");
        }
        boolean terminated = false;
        int indexFrom = cursor.getPos();
        int indexTo = cursor.getUpperBound();
        String name = null;
        for (pos = cursor.getPos(); pos < indexTo && (ch = buffer.charAt(pos)) != '='; ++pos) {
            if (!BasicHeaderValueParser.isOneOf(ch, delimiters)) continue;
            terminated = true;
            break;
        }
        if (pos == indexTo) {
            terminated = true;
            name = buffer.substringTrimmed(indexFrom, indexTo);
        } else {
            name = buffer.substringTrimmed(indexFrom, pos);
            ++pos;
        }
        if (terminated) {
            cursor.updatePos(pos);
            return this.createNameValuePair(name, null);
        }
        String value = null;
        int i1 = pos;
        boolean qouted = false;
        boolean escaped = false;
        while (pos < indexTo) {
            char ch2 = buffer.charAt(pos);
            if (ch2 == '\"' && !escaped) {
                boolean bl = qouted = !qouted;
            }
            if (!qouted && !escaped && BasicHeaderValueParser.isOneOf(ch2, delimiters)) {
                terminated = true;
                break;
            }
            escaped = escaped ? false : qouted && ch2 == '\\';
            ++pos;
        }
        int i2 = pos;
        while (i1 < i2 && HTTP.isWhitespace(buffer.charAt(i1))) {
            ++i1;
        }
        while (i2 > i1 && HTTP.isWhitespace(buffer.charAt(i2 - 1))) {
            --i2;
        }
        if (i2 - i1 >= 2 && buffer.charAt(i1) == '\"' && buffer.charAt(i2 - 1) == '\"') {
            ++i1;
            --i2;
        }
        value = buffer.substring(i1, i2);
        if (terminated) {
            ++pos;
        }
        cursor.updatePos(pos);
        return this.createNameValuePair(name, value);
    }

    private final NameValuePair $$robo$$org_apache_http_message_BasicHeaderValueParser$createNameValuePair(String name, String value) {
        return new BasicNameValuePair(name, value);
    }

    static void __staticInitializer__() {
        DEFAULT = new BasicHeaderValueParser();
        ALL_DELIMITERS = new char[]{';', ','};
    }

    private void __constructor__() {
        this.$$robo$$org_apache_http_message_BasicHeaderValueParser$__constructor__();
    }

    public BasicHeaderValueParser() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_message_BasicHeaderValueParser$__constructor__(), 0, this);
    }

    public static HeaderElement[] parseElements(String string2, HeaderValueParser headerValueParser) throws ParseException {
        return InvokeDynamicSupport.bootstrapStatic("parseElements", $$robo$$org_apache_http_message_BasicHeaderValueParser$parseElements(java.lang.String org.apache.http.message.HeaderValueParser ), 0, (String)string2, (HeaderValueParser)headerValueParser);
    }

    @Override
    public HeaderElement[] parseElements(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor) {
        return InvokeDynamicSupport.bootstrap("parseElements", $$robo$$org_apache_http_message_BasicHeaderValueParser$parseElements(org.apache.http.util.CharArrayBuffer org.apache.http.message.ParserCursor ), 0, this, charArrayBuffer, parserCursor);
    }

    public static HeaderElement parseHeaderElement(String string2, HeaderValueParser headerValueParser) throws ParseException {
        return InvokeDynamicSupport.bootstrapStatic("parseHeaderElement", $$robo$$org_apache_http_message_BasicHeaderValueParser$parseHeaderElement(java.lang.String org.apache.http.message.HeaderValueParser ), 0, (String)string2, (HeaderValueParser)headerValueParser);
    }

    @Override
    public HeaderElement parseHeaderElement(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor) {
        return InvokeDynamicSupport.bootstrap("parseHeaderElement", $$robo$$org_apache_http_message_BasicHeaderValueParser$parseHeaderElement(org.apache.http.util.CharArrayBuffer org.apache.http.message.ParserCursor ), 0, this, charArrayBuffer, parserCursor);
    }

    protected HeaderElement createHeaderElement(String string2, String string3, NameValuePair[] nameValuePairArray) {
        return InvokeDynamicSupport.bootstrap("createHeaderElement", $$robo$$org_apache_http_message_BasicHeaderValueParser$createHeaderElement(java.lang.String java.lang.String org.apache.http.NameValuePair[] ), 0, this, string2, string3, nameValuePairArray);
    }

    public static NameValuePair[] parseParameters(String string2, HeaderValueParser headerValueParser) throws ParseException {
        return InvokeDynamicSupport.bootstrapStatic("parseParameters", $$robo$$org_apache_http_message_BasicHeaderValueParser$parseParameters(java.lang.String org.apache.http.message.HeaderValueParser ), 0, (String)string2, (HeaderValueParser)headerValueParser);
    }

    @Override
    public NameValuePair[] parseParameters(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor) {
        return InvokeDynamicSupport.bootstrap("parseParameters", $$robo$$org_apache_http_message_BasicHeaderValueParser$parseParameters(org.apache.http.util.CharArrayBuffer org.apache.http.message.ParserCursor ), 0, this, charArrayBuffer, parserCursor);
    }

    public static NameValuePair parseNameValuePair(String string2, HeaderValueParser headerValueParser) throws ParseException {
        return InvokeDynamicSupport.bootstrapStatic("parseNameValuePair", $$robo$$org_apache_http_message_BasicHeaderValueParser$parseNameValuePair(java.lang.String org.apache.http.message.HeaderValueParser ), 0, (String)string2, (HeaderValueParser)headerValueParser);
    }

    @Override
    public NameValuePair parseNameValuePair(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor) {
        return InvokeDynamicSupport.bootstrap("parseNameValuePair", $$robo$$org_apache_http_message_BasicHeaderValueParser$parseNameValuePair(org.apache.http.util.CharArrayBuffer org.apache.http.message.ParserCursor ), 0, this, charArrayBuffer, parserCursor);
    }

    private static boolean isOneOf(char c, char[] cArray) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isOneOf", $$robo$$org_apache_http_message_BasicHeaderValueParser$isOneOf(char char[] ), 0, (char)c, (char[])cArray);
    }

    public NameValuePair parseNameValuePair(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor, char[] cArray) {
        return InvokeDynamicSupport.bootstrap("parseNameValuePair", $$robo$$org_apache_http_message_BasicHeaderValueParser$parseNameValuePair(org.apache.http.util.CharArrayBuffer org.apache.http.message.ParserCursor char[] ), 0, this, charArrayBuffer, parserCursor, cArray);
    }

    protected NameValuePair createNameValuePair(String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("createNameValuePair", $$robo$$org_apache_http_message_BasicHeaderValueParser$createNameValuePair(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    static {
        RobolectricInternals.classInitializing(BasicHeaderValueParser.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BasicHeaderValueParser)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

