/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import org.apache.http.FormattedHeader;
import org.apache.http.Header;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.StatusLine;
import org.apache.http.message.LineFormatter;
import org.apache.http.util.CharArrayBuffer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class BasicLineFormatter
implements LineFormatter,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static BasicLineFormatter DEFAULT;

    private void $$robo$$org_apache_http_message_BasicLineFormatter$__constructor__() {
    }

    private final CharArrayBuffer $$robo$$org_apache_http_message_BasicLineFormatter$initBuffer(CharArrayBuffer buffer) {
        if (buffer != null) {
            buffer.clear();
        } else {
            buffer = new CharArrayBuffer(64);
        }
        return buffer;
    }

    private static final String $$robo$$org_apache_http_message_BasicLineFormatter$formatProtocolVersion(ProtocolVersion version, LineFormatter formatter) {
        if (formatter == null) {
            formatter = DEFAULT;
        }
        return formatter.appendProtocolVersion(null, version).toString();
    }

    private final CharArrayBuffer $$robo$$org_apache_http_message_BasicLineFormatter$appendProtocolVersion(CharArrayBuffer buffer, ProtocolVersion version) {
        if (version == null) {
            throw new IllegalArgumentException("Protocol version may not be null");
        }
        CharArrayBuffer result = buffer;
        int len = this.estimateProtocolVersionLen(version);
        if (result == null) {
            result = new CharArrayBuffer(len);
        } else {
            result.ensureCapacity(len);
        }
        result.append(version.getProtocol());
        result.append('/');
        result.append(Integer.toString(version.getMajor()));
        result.append('.');
        result.append(Integer.toString(version.getMinor()));
        return result;
    }

    private final int $$robo$$org_apache_http_message_BasicLineFormatter$estimateProtocolVersionLen(ProtocolVersion version) {
        return version.getProtocol().length() + 4;
    }

    private static final String $$robo$$org_apache_http_message_BasicLineFormatter$formatRequestLine(RequestLine reqline, LineFormatter formatter) {
        if (formatter == null) {
            formatter = DEFAULT;
        }
        return formatter.formatRequestLine(null, reqline).toString();
    }

    private final CharArrayBuffer $$robo$$org_apache_http_message_BasicLineFormatter$formatRequestLine(CharArrayBuffer buffer, RequestLine reqline) {
        if (reqline == null) {
            throw new IllegalArgumentException("Request line may not be null");
        }
        CharArrayBuffer result = this.initBuffer(buffer);
        this.doFormatRequestLine(result, reqline);
        return result;
    }

    private final void $$robo$$org_apache_http_message_BasicLineFormatter$doFormatRequestLine(CharArrayBuffer buffer, RequestLine reqline) {
        String method = reqline.getMethod();
        String uri = reqline.getUri();
        int len = method.length() + 1 + uri.length() + 1 + this.estimateProtocolVersionLen(reqline.getProtocolVersion());
        buffer.ensureCapacity(len);
        buffer.append(method);
        buffer.append(' ');
        buffer.append(uri);
        buffer.append(' ');
        this.appendProtocolVersion(buffer, reqline.getProtocolVersion());
    }

    private static final String $$robo$$org_apache_http_message_BasicLineFormatter$formatStatusLine(StatusLine statline, LineFormatter formatter) {
        if (formatter == null) {
            formatter = DEFAULT;
        }
        return formatter.formatStatusLine(null, statline).toString();
    }

    private final CharArrayBuffer $$robo$$org_apache_http_message_BasicLineFormatter$formatStatusLine(CharArrayBuffer buffer, StatusLine statline) {
        if (statline == null) {
            throw new IllegalArgumentException("Status line may not be null");
        }
        CharArrayBuffer result = this.initBuffer(buffer);
        this.doFormatStatusLine(result, statline);
        return result;
    }

    private final void $$robo$$org_apache_http_message_BasicLineFormatter$doFormatStatusLine(CharArrayBuffer buffer, StatusLine statline) {
        int len = this.estimateProtocolVersionLen(statline.getProtocolVersion()) + 1 + 3 + 1;
        String reason = statline.getReasonPhrase();
        if (reason != null) {
            len += reason.length();
        }
        buffer.ensureCapacity(len);
        this.appendProtocolVersion(buffer, statline.getProtocolVersion());
        buffer.append(' ');
        buffer.append(Integer.toString(statline.getStatusCode()));
        buffer.append(' ');
        if (reason != null) {
            buffer.append(reason);
        }
    }

    private static final String $$robo$$org_apache_http_message_BasicLineFormatter$formatHeader(Header header, LineFormatter formatter) {
        if (formatter == null) {
            formatter = DEFAULT;
        }
        return formatter.formatHeader(null, header).toString();
    }

    private final CharArrayBuffer $$robo$$org_apache_http_message_BasicLineFormatter$formatHeader(CharArrayBuffer buffer, Header header) {
        if (header == null) {
            throw new IllegalArgumentException("Header may not be null");
        }
        CharArrayBuffer result = null;
        if (header instanceof FormattedHeader) {
            result = ((FormattedHeader)header).getBuffer();
        } else {
            result = this.initBuffer(buffer);
            this.doFormatHeader(result, header);
        }
        return result;
    }

    private final void $$robo$$org_apache_http_message_BasicLineFormatter$doFormatHeader(CharArrayBuffer buffer, Header header) {
        String name = header.getName();
        String value = header.getValue();
        int len = name.length() + 2;
        if (value != null) {
            len += value.length();
        }
        buffer.ensureCapacity(len);
        buffer.append(name);
        buffer.append(": ");
        if (value != null) {
            buffer.append(value);
        }
    }

    static void __staticInitializer__() {
        DEFAULT = new BasicLineFormatter();
    }

    private void __constructor__() {
        this.$$robo$$org_apache_http_message_BasicLineFormatter$__constructor__();
    }

    public BasicLineFormatter() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_message_BasicLineFormatter$__constructor__(), 0, this);
    }

    protected CharArrayBuffer initBuffer(CharArrayBuffer charArrayBuffer) {
        return InvokeDynamicSupport.bootstrap("initBuffer", $$robo$$org_apache_http_message_BasicLineFormatter$initBuffer(org.apache.http.util.CharArrayBuffer ), 0, this, charArrayBuffer);
    }

    public static String formatProtocolVersion(ProtocolVersion protocolVersion, LineFormatter lineFormatter) {
        return InvokeDynamicSupport.bootstrapStatic("formatProtocolVersion", $$robo$$org_apache_http_message_BasicLineFormatter$formatProtocolVersion(org.apache.http.ProtocolVersion org.apache.http.message.LineFormatter ), 0, (ProtocolVersion)protocolVersion, (LineFormatter)lineFormatter);
    }

    @Override
    public CharArrayBuffer appendProtocolVersion(CharArrayBuffer charArrayBuffer, ProtocolVersion protocolVersion) {
        return InvokeDynamicSupport.bootstrap("appendProtocolVersion", $$robo$$org_apache_http_message_BasicLineFormatter$appendProtocolVersion(org.apache.http.util.CharArrayBuffer org.apache.http.ProtocolVersion ), 0, this, charArrayBuffer, protocolVersion);
    }

    protected int estimateProtocolVersionLen(ProtocolVersion protocolVersion) {
        return (int)InvokeDynamicSupport.bootstrap("estimateProtocolVersionLen", $$robo$$org_apache_http_message_BasicLineFormatter$estimateProtocolVersionLen(org.apache.http.ProtocolVersion ), 0, this, protocolVersion);
    }

    public static String formatRequestLine(RequestLine requestLine, LineFormatter lineFormatter) {
        return InvokeDynamicSupport.bootstrapStatic("formatRequestLine", $$robo$$org_apache_http_message_BasicLineFormatter$formatRequestLine(org.apache.http.RequestLine org.apache.http.message.LineFormatter ), 0, (RequestLine)requestLine, (LineFormatter)lineFormatter);
    }

    @Override
    public CharArrayBuffer formatRequestLine(CharArrayBuffer charArrayBuffer, RequestLine requestLine) {
        return InvokeDynamicSupport.bootstrap("formatRequestLine", $$robo$$org_apache_http_message_BasicLineFormatter$formatRequestLine(org.apache.http.util.CharArrayBuffer org.apache.http.RequestLine ), 0, this, charArrayBuffer, requestLine);
    }

    protected void doFormatRequestLine(CharArrayBuffer charArrayBuffer, RequestLine requestLine) {
        InvokeDynamicSupport.bootstrap("doFormatRequestLine", $$robo$$org_apache_http_message_BasicLineFormatter$doFormatRequestLine(org.apache.http.util.CharArrayBuffer org.apache.http.RequestLine ), 0, this, charArrayBuffer, requestLine);
    }

    public static String formatStatusLine(StatusLine statusLine, LineFormatter lineFormatter) {
        return InvokeDynamicSupport.bootstrapStatic("formatStatusLine", $$robo$$org_apache_http_message_BasicLineFormatter$formatStatusLine(org.apache.http.StatusLine org.apache.http.message.LineFormatter ), 0, (StatusLine)statusLine, (LineFormatter)lineFormatter);
    }

    @Override
    public CharArrayBuffer formatStatusLine(CharArrayBuffer charArrayBuffer, StatusLine statusLine) {
        return InvokeDynamicSupport.bootstrap("formatStatusLine", $$robo$$org_apache_http_message_BasicLineFormatter$formatStatusLine(org.apache.http.util.CharArrayBuffer org.apache.http.StatusLine ), 0, this, charArrayBuffer, statusLine);
    }

    protected void doFormatStatusLine(CharArrayBuffer charArrayBuffer, StatusLine statusLine) {
        InvokeDynamicSupport.bootstrap("doFormatStatusLine", $$robo$$org_apache_http_message_BasicLineFormatter$doFormatStatusLine(org.apache.http.util.CharArrayBuffer org.apache.http.StatusLine ), 0, this, charArrayBuffer, statusLine);
    }

    public static String formatHeader(Header header, LineFormatter lineFormatter) {
        return InvokeDynamicSupport.bootstrapStatic("formatHeader", $$robo$$org_apache_http_message_BasicLineFormatter$formatHeader(org.apache.http.Header org.apache.http.message.LineFormatter ), 0, (Header)header, (LineFormatter)lineFormatter);
    }

    @Override
    public CharArrayBuffer formatHeader(CharArrayBuffer charArrayBuffer, Header header) {
        return InvokeDynamicSupport.bootstrap("formatHeader", $$robo$$org_apache_http_message_BasicLineFormatter$formatHeader(org.apache.http.util.CharArrayBuffer org.apache.http.Header ), 0, this, charArrayBuffer, header);
    }

    protected void doFormatHeader(CharArrayBuffer charArrayBuffer, Header header) {
        InvokeDynamicSupport.bootstrap("doFormatHeader", $$robo$$org_apache_http_message_BasicLineFormatter$doFormatHeader(org.apache.http.util.CharArrayBuffer org.apache.http.Header ), 0, this, charArrayBuffer, header);
    }

    static {
        RobolectricInternals.classInitializing(BasicLineFormatter.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BasicLineFormatter)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

