/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import org.apache.http.Header;
import org.apache.http.HttpVersion;
import org.apache.http.ParseException;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.StatusLine;
import org.apache.http.message.BasicRequestLine;
import org.apache.http.message.BasicStatusLine;
import org.apache.http.message.BufferedHeader;
import org.apache.http.message.LineParser;
import org.apache.http.message.ParserCursor;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.CharArrayBuffer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class BasicLineParser
implements LineParser,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static BasicLineParser DEFAULT;
    protected ProtocolVersion protocol;

    private void $$robo$$org_apache_http_message_BasicLineParser$__constructor__(ProtocolVersion proto) {
        if (proto == null) {
            proto = HttpVersion.HTTP_1_1;
        }
        this.protocol = proto;
    }

    private void $$robo$$org_apache_http_message_BasicLineParser$__constructor__() {
    }

    private static final ProtocolVersion $$robo$$org_apache_http_message_BasicLineParser$parseProtocolVersion(String value, LineParser parser) throws ParseException {
        if (value == null) {
            throw new IllegalArgumentException("Value to parse may not be null.");
        }
        if (parser == null) {
            parser = DEFAULT;
        }
        CharArrayBuffer buffer = new CharArrayBuffer(value.length());
        buffer.append(value);
        ParserCursor cursor = new ParserCursor(0, value.length());
        return parser.parseProtocolVersion(buffer, cursor);
    }

    private final ProtocolVersion $$robo$$org_apache_http_message_BasicLineParser$parseProtocolVersion(CharArrayBuffer buffer, ParserCursor cursor) throws ParseException {
        int minor;
        int major;
        if (buffer == null) {
            throw new IllegalArgumentException("Char array buffer may not be null");
        }
        if (cursor == null) {
            throw new IllegalArgumentException("Parser cursor may not be null");
        }
        String protoname = this.protocol.getProtocol();
        int protolength = protoname.length();
        int indexFrom = cursor.getPos();
        int indexTo = cursor.getUpperBound();
        this.skipWhitespace(buffer, cursor);
        int i = cursor.getPos();
        if (i + protolength + 4 > indexTo) {
            throw new ParseException("Not a valid protocol version: " + buffer.substring(indexFrom, indexTo));
        }
        boolean ok = true;
        for (int j = 0; ok && j < protolength; ++j) {
            ok = buffer.charAt(i + j) == protoname.charAt(j);
        }
        if (ok) {
            boolean bl = ok = buffer.charAt(i + protolength) == '/';
        }
        if (!ok) {
            throw new ParseException("Not a valid protocol version: " + buffer.substring(indexFrom, indexTo));
        }
        int period = buffer.indexOf(46, i += protolength + 1, indexTo);
        if (period == -1) {
            throw new ParseException("Invalid protocol version number: " + buffer.substring(indexFrom, indexTo));
        }
        try {
            major = Integer.parseInt(buffer.substringTrimmed(i, period));
        }
        catch (NumberFormatException e) {
            throw new ParseException("Invalid protocol major version number: " + buffer.substring(indexFrom, indexTo));
        }
        i = period + 1;
        int blank = buffer.indexOf(32, i, indexTo);
        if (blank == -1) {
            blank = indexTo;
        }
        try {
            minor = Integer.parseInt(buffer.substringTrimmed(i, blank));
        }
        catch (NumberFormatException e) {
            throw new ParseException("Invalid protocol minor version number: " + buffer.substring(indexFrom, indexTo));
        }
        cursor.updatePos(blank);
        return this.createProtocolVersion(major, minor);
    }

    private final ProtocolVersion $$robo$$org_apache_http_message_BasicLineParser$createProtocolVersion(int major, int minor) {
        return this.protocol.forVersion(major, minor);
    }

    private final boolean $$robo$$org_apache_http_message_BasicLineParser$hasProtocolVersion(CharArrayBuffer buffer, ParserCursor cursor) {
        int index;
        if (buffer == null) {
            throw new IllegalArgumentException("Char array buffer may not be null");
        }
        if (cursor == null) {
            throw new IllegalArgumentException("Parser cursor may not be null");
        }
        String protoname = this.protocol.getProtocol();
        int protolength = protoname.length();
        if (buffer.length() < protolength + 4) {
            return false;
        }
        if (index < 0) {
            index = buffer.length() - 4 - protolength;
        } else if (index == 0) {
            for (index = cursor.getPos(); index < buffer.length() && HTTP.isWhitespace(buffer.charAt(index)); ++index) {
            }
        }
        if (index + protolength + 4 > buffer.length()) {
            return false;
        }
        boolean ok = true;
        for (int j = 0; ok && j < protolength; ++j) {
            ok = buffer.charAt(index + j) == protoname.charAt(j);
        }
        if (ok) {
            ok = buffer.charAt(index + protolength) == '/';
        }
        return ok;
    }

    private static final RequestLine $$robo$$org_apache_http_message_BasicLineParser$parseRequestLine(String value, LineParser parser) throws ParseException {
        if (value == null) {
            throw new IllegalArgumentException("Value to parse may not be null.");
        }
        if (parser == null) {
            parser = DEFAULT;
        }
        CharArrayBuffer buffer = new CharArrayBuffer(value.length());
        buffer.append(value);
        ParserCursor cursor = new ParserCursor(0, value.length());
        return parser.parseRequestLine(buffer, cursor);
    }

    private final RequestLine $$robo$$org_apache_http_message_BasicLineParser$parseRequestLine(CharArrayBuffer buffer, ParserCursor cursor) throws ParseException {
        if (buffer == null) {
            throw new IllegalArgumentException("Char array buffer may not be null");
        }
        if (cursor == null) {
            throw new IllegalArgumentException("Parser cursor may not be null");
        }
        int indexFrom = cursor.getPos();
        int indexTo = cursor.getUpperBound();
        try {
            this.skipWhitespace(buffer, cursor);
            int i = cursor.getPos();
            int blank = buffer.indexOf(32, i, indexTo);
            if (blank < 0) {
                throw new ParseException("Invalid request line: " + buffer.substring(indexFrom, indexTo));
            }
            String method = buffer.substringTrimmed(i, blank);
            cursor.updatePos(blank);
            this.skipWhitespace(buffer, cursor);
            i = cursor.getPos();
            blank = buffer.indexOf(32, i, indexTo);
            if (blank < 0) {
                throw new ParseException("Invalid request line: " + buffer.substring(indexFrom, indexTo));
            }
            String uri = buffer.substringTrimmed(i, blank);
            cursor.updatePos(blank);
            ProtocolVersion ver = this.parseProtocolVersion(buffer, cursor);
            this.skipWhitespace(buffer, cursor);
            if (!cursor.atEnd()) {
                throw new ParseException("Invalid request line: " + buffer.substring(indexFrom, indexTo));
            }
            return this.createRequestLine(method, uri, ver);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ParseException("Invalid request line: " + buffer.substring(indexFrom, indexTo));
        }
    }

    private final RequestLine $$robo$$org_apache_http_message_BasicLineParser$createRequestLine(String method, String uri, ProtocolVersion ver) {
        return new BasicRequestLine(method, uri, ver);
    }

    private static final StatusLine $$robo$$org_apache_http_message_BasicLineParser$parseStatusLine(String value, LineParser parser) throws ParseException {
        if (value == null) {
            throw new IllegalArgumentException("Value to parse may not be null.");
        }
        if (parser == null) {
            parser = DEFAULT;
        }
        CharArrayBuffer buffer = new CharArrayBuffer(value.length());
        buffer.append(value);
        ParserCursor cursor = new ParserCursor(0, value.length());
        return parser.parseStatusLine(buffer, cursor);
    }

    private final StatusLine $$robo$$org_apache_http_message_BasicLineParser$parseStatusLine(CharArrayBuffer buffer, ParserCursor cursor) throws ParseException {
        if (buffer == null) {
            throw new IllegalArgumentException("Char array buffer may not be null");
        }
        if (cursor == null) {
            throw new IllegalArgumentException("Parser cursor may not be null");
        }
        int indexFrom = cursor.getPos();
        int indexTo = cursor.getUpperBound();
        try {
            ProtocolVersion ver = this.parseProtocolVersion(buffer, cursor);
            this.skipWhitespace(buffer, cursor);
            int i = cursor.getPos();
            int blank = buffer.indexOf(32, i, indexTo);
            if (blank < 0) {
                blank = indexTo;
            }
            int statusCode = 0;
            try {
                statusCode = Integer.parseInt(buffer.substringTrimmed(i, blank));
            }
            catch (NumberFormatException e) {
                throw new ParseException("Unable to parse status code from status line: " + buffer.substring(indexFrom, indexTo));
            }
            i = blank;
            String reasonPhrase = null;
            reasonPhrase = i < indexTo ? buffer.substringTrimmed(i, indexTo) : "";
            return this.createStatusLine(ver, statusCode, reasonPhrase);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ParseException("Invalid status line: " + buffer.substring(indexFrom, indexTo));
        }
    }

    private final StatusLine $$robo$$org_apache_http_message_BasicLineParser$createStatusLine(ProtocolVersion ver, int status, String reason) {
        return new BasicStatusLine(ver, status, reason);
    }

    private static final Header $$robo$$org_apache_http_message_BasicLineParser$parseHeader(String value, LineParser parser) throws ParseException {
        if (value == null) {
            throw new IllegalArgumentException("Value to parse may not be null");
        }
        if (parser == null) {
            parser = DEFAULT;
        }
        CharArrayBuffer buffer = new CharArrayBuffer(value.length());
        buffer.append(value);
        return parser.parseHeader(buffer);
    }

    private final Header $$robo$$org_apache_http_message_BasicLineParser$parseHeader(CharArrayBuffer buffer) throws ParseException {
        return new BufferedHeader(buffer);
    }

    private final void $$robo$$org_apache_http_message_BasicLineParser$skipWhitespace(CharArrayBuffer buffer, ParserCursor cursor) {
        int pos;
        int indexTo = cursor.getUpperBound();
        for (pos = cursor.getPos(); pos < indexTo && HTTP.isWhitespace(buffer.charAt(pos)); ++pos) {
        }
        cursor.updatePos(pos);
    }

    static void __staticInitializer__() {
        DEFAULT = new BasicLineParser();
    }

    private void __constructor__(ProtocolVersion protocolVersion) {
        this.$$robo$$org_apache_http_message_BasicLineParser$__constructor__(protocolVersion);
    }

    public BasicLineParser(ProtocolVersion protocolVersion) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_message_BasicLineParser$__constructor__(org.apache.http.ProtocolVersion ), 0, this, protocolVersion);
    }

    private void __constructor__() {
        this.$$robo$$org_apache_http_message_BasicLineParser$__constructor__();
    }

    public BasicLineParser() {
        this(null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_message_BasicLineParser$__constructor__(), 0, this);
    }

    public static ProtocolVersion parseProtocolVersion(String string2, LineParser lineParser) throws ParseException {
        return InvokeDynamicSupport.bootstrapStatic("parseProtocolVersion", $$robo$$org_apache_http_message_BasicLineParser$parseProtocolVersion(java.lang.String org.apache.http.message.LineParser ), 0, (String)string2, (LineParser)lineParser);
    }

    @Override
    public ProtocolVersion parseProtocolVersion(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor) throws ParseException {
        return InvokeDynamicSupport.bootstrap("parseProtocolVersion", $$robo$$org_apache_http_message_BasicLineParser$parseProtocolVersion(org.apache.http.util.CharArrayBuffer org.apache.http.message.ParserCursor ), 0, this, charArrayBuffer, parserCursor);
    }

    protected ProtocolVersion createProtocolVersion(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("createProtocolVersion", $$robo$$org_apache_http_message_BasicLineParser$createProtocolVersion(int int ), 0, this, n, n2);
    }

    @Override
    public boolean hasProtocolVersion(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasProtocolVersion", $$robo$$org_apache_http_message_BasicLineParser$hasProtocolVersion(org.apache.http.util.CharArrayBuffer org.apache.http.message.ParserCursor ), 0, this, charArrayBuffer, parserCursor);
    }

    public static RequestLine parseRequestLine(String string2, LineParser lineParser) throws ParseException {
        return InvokeDynamicSupport.bootstrapStatic("parseRequestLine", $$robo$$org_apache_http_message_BasicLineParser$parseRequestLine(java.lang.String org.apache.http.message.LineParser ), 0, (String)string2, (LineParser)lineParser);
    }

    @Override
    public RequestLine parseRequestLine(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor) throws ParseException {
        return InvokeDynamicSupport.bootstrap("parseRequestLine", $$robo$$org_apache_http_message_BasicLineParser$parseRequestLine(org.apache.http.util.CharArrayBuffer org.apache.http.message.ParserCursor ), 0, this, charArrayBuffer, parserCursor);
    }

    protected RequestLine createRequestLine(String string2, String string3, ProtocolVersion protocolVersion) {
        return InvokeDynamicSupport.bootstrap("createRequestLine", $$robo$$org_apache_http_message_BasicLineParser$createRequestLine(java.lang.String java.lang.String org.apache.http.ProtocolVersion ), 0, this, string2, string3, protocolVersion);
    }

    public static StatusLine parseStatusLine(String string2, LineParser lineParser) throws ParseException {
        return InvokeDynamicSupport.bootstrapStatic("parseStatusLine", $$robo$$org_apache_http_message_BasicLineParser$parseStatusLine(java.lang.String org.apache.http.message.LineParser ), 0, (String)string2, (LineParser)lineParser);
    }

    @Override
    public StatusLine parseStatusLine(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor) throws ParseException {
        return InvokeDynamicSupport.bootstrap("parseStatusLine", $$robo$$org_apache_http_message_BasicLineParser$parseStatusLine(org.apache.http.util.CharArrayBuffer org.apache.http.message.ParserCursor ), 0, this, charArrayBuffer, parserCursor);
    }

    protected StatusLine createStatusLine(ProtocolVersion protocolVersion, int n, String string2) {
        return InvokeDynamicSupport.bootstrap("createStatusLine", $$robo$$org_apache_http_message_BasicLineParser$createStatusLine(org.apache.http.ProtocolVersion int java.lang.String ), 0, this, protocolVersion, n, string2);
    }

    public static Header parseHeader(String string2, LineParser lineParser) throws ParseException {
        return InvokeDynamicSupport.bootstrapStatic("parseHeader", $$robo$$org_apache_http_message_BasicLineParser$parseHeader(java.lang.String org.apache.http.message.LineParser ), 0, (String)string2, (LineParser)lineParser);
    }

    @Override
    public Header parseHeader(CharArrayBuffer charArrayBuffer) throws ParseException {
        return InvokeDynamicSupport.bootstrap("parseHeader", $$robo$$org_apache_http_message_BasicLineParser$parseHeader(org.apache.http.util.CharArrayBuffer ), 0, this, charArrayBuffer);
    }

    protected void skipWhitespace(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor) {
        InvokeDynamicSupport.bootstrap("skipWhitespace", $$robo$$org_apache_http_message_BasicLineParser$skipWhitespace(org.apache.http.util.CharArrayBuffer org.apache.http.message.ParserCursor ), 0, this, charArrayBuffer, parserCursor);
    }

    static {
        RobolectricInternals.classInitializing(BasicLineParser.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BasicLineParser)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

