/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import java.util.List;
import java.util.NoSuchElementException;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class BasicListHeaderIterator
implements HeaderIterator,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    protected List allHeaders;
    protected int currentIndex;
    protected int lastIndex;
    protected String headerName;

    private void $$robo$$org_apache_http_message_BasicListHeaderIterator$__constructor__(List headers, String name) {
        if (headers == null) {
            throw new IllegalArgumentException("Header list must not be null.");
        }
        this.allHeaders = headers;
        this.headerName = name;
        this.currentIndex = this.findNext(-1);
        this.lastIndex = -1;
    }

    private final int $$robo$$org_apache_http_message_BasicListHeaderIterator$findNext(int from) {
        if (from < -1) {
            return -1;
        }
        int to = this.allHeaders.size() - 1;
        boolean found = false;
        while (!found && from < to) {
            found = this.filterHeader(++from);
        }
        return found ? from : -1;
    }

    private final boolean $$robo$$org_apache_http_message_BasicListHeaderIterator$filterHeader(int index) {
        if (this.headerName == null) {
            return true;
        }
        String name = ((Header)this.allHeaders.get(index)).getName();
        return this.headerName.equalsIgnoreCase(name);
    }

    private final boolean $$robo$$org_apache_http_message_BasicListHeaderIterator$hasNext() {
        return this.currentIndex >= 0;
    }

    private final Header $$robo$$org_apache_http_message_BasicListHeaderIterator$nextHeader() throws NoSuchElementException {
        int current = this.currentIndex;
        if (current < 0) {
            throw new NoSuchElementException("Iteration already finished.");
        }
        this.lastIndex = current;
        this.currentIndex = this.findNext(current);
        return (Header)this.allHeaders.get(current);
    }

    private final Object $$robo$$org_apache_http_message_BasicListHeaderIterator$next() throws NoSuchElementException {
        return this.nextHeader();
    }

    private final void $$robo$$org_apache_http_message_BasicListHeaderIterator$remove() throws UnsupportedOperationException {
        if (this.lastIndex < 0) {
            throw new IllegalStateException("No header to remove.");
        }
        this.allHeaders.remove(this.lastIndex);
        this.lastIndex = -1;
        --this.currentIndex;
    }

    private void __constructor__(List list, String string2) {
        this.$$robo$$org_apache_http_message_BasicListHeaderIterator$__constructor__(list, string2);
    }

    public BasicListHeaderIterator(List list, String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_message_BasicListHeaderIterator$__constructor__(java.util.List java.lang.String ), 0, this, list, string2);
    }

    protected int findNext(int n) {
        return (int)InvokeDynamicSupport.bootstrap("findNext", $$robo$$org_apache_http_message_BasicListHeaderIterator$findNext(int ), 0, this, n);
    }

    protected boolean filterHeader(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("filterHeader", $$robo$$org_apache_http_message_BasicListHeaderIterator$filterHeader(int ), 0, this, n);
    }

    @Override
    public boolean hasNext() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasNext", $$robo$$org_apache_http_message_BasicListHeaderIterator$hasNext(), 0, this);
    }

    @Override
    public Header nextHeader() throws NoSuchElementException {
        return InvokeDynamicSupport.bootstrap("nextHeader", $$robo$$org_apache_http_message_BasicListHeaderIterator$nextHeader(), 0, this);
    }

    public Object next() throws NoSuchElementException {
        return InvokeDynamicSupport.bootstrap("next", $$robo$$org_apache_http_message_BasicListHeaderIterator$next(), 0, this);
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        InvokeDynamicSupport.bootstrap("remove", $$robo$$org_apache_http_message_BasicListHeaderIterator$remove(), 0, this);
    }

    public /* synthetic */ BasicListHeaderIterator() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BasicListHeaderIterator)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

