/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import java.util.NoSuchElementException;
import org.apache.http.HeaderIterator;
import org.apache.http.ParseException;
import org.apache.http.TokenIterator;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class BasicTokenIterator
implements TokenIterator,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String HTTP_SEPARATORS = " ,;=()<>@:\\\"/[]?{}\t";
    protected HeaderIterator headerIt;
    protected String currentHeader;
    protected String currentToken;
    protected int searchPos;

    private void $$robo$$org_apache_http_message_BasicTokenIterator$__constructor__(HeaderIterator headerIterator) {
        if (headerIterator == null) {
            throw new IllegalArgumentException("Header iterator must not be null.");
        }
        this.headerIt = headerIterator;
        this.searchPos = this.findNext(-1);
    }

    private final boolean $$robo$$org_apache_http_message_BasicTokenIterator$hasNext() {
        return this.currentToken != null;
    }

    private final String $$robo$$org_apache_http_message_BasicTokenIterator$nextToken() throws NoSuchElementException, ParseException {
        if (this.currentToken == null) {
            throw new NoSuchElementException("Iteration already finished.");
        }
        String result = this.currentToken;
        this.searchPos = this.findNext(this.searchPos);
        return result;
    }

    private final Object $$robo$$org_apache_http_message_BasicTokenIterator$next() throws NoSuchElementException, ParseException {
        return this.nextToken();
    }

    private final void $$robo$$org_apache_http_message_BasicTokenIterator$remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Removing tokens is not supported.");
    }

    private final int $$robo$$org_apache_http_message_BasicTokenIterator$findNext(int from) throws ParseException {
        if (from < 0) {
            if (!this.headerIt.hasNext()) {
                return -1;
            }
            this.currentHeader = this.headerIt.nextHeader().getValue();
            from = 0;
        } else {
            from = this.findTokenSeparator(from);
        }
        int start = this.findTokenStart(from);
        if (start < 0) {
            this.currentToken = null;
            return -1;
        }
        int end = this.findTokenEnd(start);
        this.currentToken = this.createToken(this.currentHeader, start, end);
        return end;
    }

    private final String $$robo$$org_apache_http_message_BasicTokenIterator$createToken(String value, int start, int end) {
        return value.substring(start, end);
    }

    private final int $$robo$$org_apache_http_message_BasicTokenIterator$findTokenStart(int from) {
        if (from < 0) {
            throw new IllegalArgumentException("Search position must not be negative: " + from);
        }
        boolean found = false;
        while (!found && this.currentHeader != null) {
            int to = this.currentHeader.length();
            while (!found && from < to) {
                char ch = this.currentHeader.charAt(from);
                if (this.isTokenSeparator(ch) || this.isWhitespace(ch)) {
                    ++from;
                    continue;
                }
                if (this.isTokenChar(this.currentHeader.charAt(from))) {
                    found = true;
                    continue;
                }
                throw new ParseException("Invalid character before token (pos " + from + "): " + this.currentHeader);
            }
            if (found) continue;
            if (this.headerIt.hasNext()) {
                this.currentHeader = this.headerIt.nextHeader().getValue();
                from = 0;
                continue;
            }
            this.currentHeader = null;
        }
        return found ? from : -1;
    }

    private final int $$robo$$org_apache_http_message_BasicTokenIterator$findTokenSeparator(int from) {
        if (from < 0) {
            throw new IllegalArgumentException("Search position must not be negative: " + from);
        }
        boolean found = false;
        int to = this.currentHeader.length();
        while (!found && from < to) {
            char ch = this.currentHeader.charAt(from);
            if (this.isTokenSeparator(ch)) {
                found = true;
                continue;
            }
            if (this.isWhitespace(ch)) {
                ++from;
                continue;
            }
            if (this.isTokenChar(ch)) {
                throw new ParseException("Tokens without separator (pos " + from + "): " + this.currentHeader);
            }
            throw new ParseException("Invalid character after token (pos " + from + "): " + this.currentHeader);
        }
        return from;
    }

    private final int $$robo$$org_apache_http_message_BasicTokenIterator$findTokenEnd(int from) {
        int end;
        if (from < 0) {
            throw new IllegalArgumentException("Token start position must not be negative: " + from);
        }
        int to = this.currentHeader.length();
        for (end = from + 1; end < to && this.isTokenChar(this.currentHeader.charAt(end)); ++end) {
        }
        return end;
    }

    private final boolean $$robo$$org_apache_http_message_BasicTokenIterator$isTokenSeparator(char ch) {
        return ch == ',';
    }

    private final boolean $$robo$$org_apache_http_message_BasicTokenIterator$isWhitespace(char ch) {
        return ch == '\t' || Character.isSpaceChar(ch);
    }

    private final boolean $$robo$$org_apache_http_message_BasicTokenIterator$isTokenChar(char ch) {
        if (Character.isLetterOrDigit(ch)) {
            return true;
        }
        if (Character.isISOControl(ch)) {
            return false;
        }
        return !this.isHttpSeparator(ch);
    }

    private final boolean $$robo$$org_apache_http_message_BasicTokenIterator$isHttpSeparator(char ch) {
        return " ,;=()<>@:\\\"/[]?{}\t".indexOf(ch) >= 0;
    }

    private void __constructor__(HeaderIterator headerIterator) {
        this.$$robo$$org_apache_http_message_BasicTokenIterator$__constructor__(headerIterator);
    }

    public BasicTokenIterator(HeaderIterator headerIterator) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_message_BasicTokenIterator$__constructor__(org.apache.http.HeaderIterator ), 0, this, headerIterator);
    }

    @Override
    public boolean hasNext() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasNext", $$robo$$org_apache_http_message_BasicTokenIterator$hasNext(), 0, this);
    }

    @Override
    public String nextToken() throws NoSuchElementException, ParseException {
        return InvokeDynamicSupport.bootstrap("nextToken", $$robo$$org_apache_http_message_BasicTokenIterator$nextToken(), 0, this);
    }

    public Object next() throws NoSuchElementException, ParseException {
        return InvokeDynamicSupport.bootstrap("next", $$robo$$org_apache_http_message_BasicTokenIterator$next(), 0, this);
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        InvokeDynamicSupport.bootstrap("remove", $$robo$$org_apache_http_message_BasicTokenIterator$remove(), 0, this);
    }

    protected int findNext(int n) throws ParseException {
        return (int)InvokeDynamicSupport.bootstrap("findNext", $$robo$$org_apache_http_message_BasicTokenIterator$findNext(int ), 0, this, n);
    }

    protected String createToken(String string2, int n, int n2) {
        return InvokeDynamicSupport.bootstrap("createToken", $$robo$$org_apache_http_message_BasicTokenIterator$createToken(java.lang.String int int ), 0, this, string2, n, n2);
    }

    protected int findTokenStart(int n) {
        return (int)InvokeDynamicSupport.bootstrap("findTokenStart", $$robo$$org_apache_http_message_BasicTokenIterator$findTokenStart(int ), 0, this, n);
    }

    protected int findTokenSeparator(int n) {
        return (int)InvokeDynamicSupport.bootstrap("findTokenSeparator", $$robo$$org_apache_http_message_BasicTokenIterator$findTokenSeparator(int ), 0, this, n);
    }

    protected int findTokenEnd(int n) {
        return (int)InvokeDynamicSupport.bootstrap("findTokenEnd", $$robo$$org_apache_http_message_BasicTokenIterator$findTokenEnd(int ), 0, this, n);
    }

    protected boolean isTokenSeparator(char c) {
        return (boolean)InvokeDynamicSupport.bootstrap("isTokenSeparator", $$robo$$org_apache_http_message_BasicTokenIterator$isTokenSeparator(char ), 0, this, c);
    }

    protected boolean isWhitespace(char c) {
        return (boolean)InvokeDynamicSupport.bootstrap("isWhitespace", $$robo$$org_apache_http_message_BasicTokenIterator$isWhitespace(char ), 0, this, c);
    }

    protected boolean isTokenChar(char c) {
        return (boolean)InvokeDynamicSupport.bootstrap("isTokenChar", $$robo$$org_apache_http_message_BasicTokenIterator$isTokenChar(char ), 0, this, c);
    }

    protected boolean isHttpSeparator(char c) {
        return (boolean)InvokeDynamicSupport.bootstrap("isHttpSeparator", $$robo$$org_apache_http_message_BasicTokenIterator$isHttpSeparator(char ), 0, this, c);
    }

    public /* synthetic */ BasicTokenIterator() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BasicTokenIterator)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

