/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.protocol;

import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestInterceptorList;
import org.apache.http.protocol.HttpResponseInterceptorList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class BasicHttpProcessor
implements HttpProcessor,
HttpRequestInterceptorList,
HttpResponseInterceptorList,
Cloneable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    protected List requestInterceptors;
    protected List responseInterceptors;

    private void $$robo$$org_apache_http_protocol_BasicHttpProcessor$__constructor__() {
        this.requestInterceptors = null;
        this.responseInterceptors = null;
    }

    private final void $$robo$$org_apache_http_protocol_BasicHttpProcessor$addRequestInterceptor(HttpRequestInterceptor itcp) {
        if (itcp == null) {
            return;
        }
        if (this.requestInterceptors == null) {
            this.requestInterceptors = new ArrayList();
        }
        this.requestInterceptors.add(itcp);
    }

    private final void $$robo$$org_apache_http_protocol_BasicHttpProcessor$addRequestInterceptor(HttpRequestInterceptor itcp, int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        if (itcp == null) {
            return;
        }
        if (this.requestInterceptors == null) {
            if (index > 0) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
            this.requestInterceptors = new ArrayList();
        }
        this.requestInterceptors.add(index, itcp);
    }

    private final void $$robo$$org_apache_http_protocol_BasicHttpProcessor$addResponseInterceptor(HttpResponseInterceptor itcp, int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        if (itcp == null) {
            return;
        }
        if (this.responseInterceptors == null) {
            if (index > 0) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
            this.responseInterceptors = new ArrayList();
        }
        this.responseInterceptors.add(index, itcp);
    }

    private final void $$robo$$org_apache_http_protocol_BasicHttpProcessor$removeRequestInterceptorByClass(Class clazz) {
        if (this.requestInterceptors == null) {
            return;
        }
        Iterator it = this.requestInterceptors.iterator();
        while (it.hasNext()) {
            Object request = it.next();
            if (!request.getClass().equals(clazz)) continue;
            it.remove();
        }
    }

    private final void $$robo$$org_apache_http_protocol_BasicHttpProcessor$removeResponseInterceptorByClass(Class clazz) {
        if (this.responseInterceptors == null) {
            return;
        }
        Iterator it = this.responseInterceptors.iterator();
        while (it.hasNext()) {
            Object request = it.next();
            if (!request.getClass().equals(clazz)) continue;
            it.remove();
        }
    }

    private final void $$robo$$org_apache_http_protocol_BasicHttpProcessor$addInterceptor(HttpRequestInterceptor interceptor) {
        this.addRequestInterceptor(interceptor);
    }

    private final void $$robo$$org_apache_http_protocol_BasicHttpProcessor$addInterceptor(HttpRequestInterceptor interceptor, int index) {
        this.addRequestInterceptor(interceptor, index);
    }

    private final int $$robo$$org_apache_http_protocol_BasicHttpProcessor$getRequestInterceptorCount() {
        return this.requestInterceptors == null ? 0 : this.requestInterceptors.size();
    }

    private final HttpRequestInterceptor $$robo$$org_apache_http_protocol_BasicHttpProcessor$getRequestInterceptor(int index) {
        if (this.requestInterceptors == null || index < 0 || index >= this.requestInterceptors.size()) {
            return null;
        }
        return (HttpRequestInterceptor)this.requestInterceptors.get(index);
    }

    private final void $$robo$$org_apache_http_protocol_BasicHttpProcessor$clearRequestInterceptors() {
        this.requestInterceptors = null;
    }

    private final void $$robo$$org_apache_http_protocol_BasicHttpProcessor$addResponseInterceptor(HttpResponseInterceptor itcp) {
        if (itcp == null) {
            return;
        }
        if (this.responseInterceptors == null) {
            this.responseInterceptors = new ArrayList();
        }
        this.responseInterceptors.add(itcp);
    }

    private final void $$robo$$org_apache_http_protocol_BasicHttpProcessor$addInterceptor(HttpResponseInterceptor interceptor) {
        this.addResponseInterceptor(interceptor);
    }

    private final void $$robo$$org_apache_http_protocol_BasicHttpProcessor$addInterceptor(HttpResponseInterceptor interceptor, int index) {
        this.addResponseInterceptor(interceptor, index);
    }

    private final int $$robo$$org_apache_http_protocol_BasicHttpProcessor$getResponseInterceptorCount() {
        return this.responseInterceptors == null ? 0 : this.responseInterceptors.size();
    }

    private final HttpResponseInterceptor $$robo$$org_apache_http_protocol_BasicHttpProcessor$getResponseInterceptor(int index) {
        if (this.responseInterceptors == null || index < 0 || index >= this.responseInterceptors.size()) {
            return null;
        }
        return (HttpResponseInterceptor)this.responseInterceptors.get(index);
    }

    private final void $$robo$$org_apache_http_protocol_BasicHttpProcessor$clearResponseInterceptors() {
        this.responseInterceptors = null;
    }

    private final void $$robo$$org_apache_http_protocol_BasicHttpProcessor$setInterceptors(List list) {
        if (list == null) {
            throw new IllegalArgumentException("List must not be null.");
        }
        if (this.requestInterceptors != null) {
            this.requestInterceptors.clear();
        }
        if (this.responseInterceptors != null) {
            this.responseInterceptors.clear();
        }
        for (int i = 0; i < list.size(); ++i) {
            Object obj = list.get(i);
            if (obj instanceof HttpRequestInterceptor) {
                this.addInterceptor((HttpRequestInterceptor)obj);
            }
            if (!(obj instanceof HttpResponseInterceptor)) continue;
            this.addInterceptor((HttpResponseInterceptor)obj);
        }
    }

    private final void $$robo$$org_apache_http_protocol_BasicHttpProcessor$clearInterceptors() {
        this.clearRequestInterceptors();
        this.clearResponseInterceptors();
    }

    private final void $$robo$$org_apache_http_protocol_BasicHttpProcessor$process(HttpRequest request, HttpContext context) throws IOException, HttpException {
        if (this.requestInterceptors != null) {
            for (int i = 0; i < this.requestInterceptors.size(); ++i) {
                HttpRequestInterceptor interceptor = (HttpRequestInterceptor)this.requestInterceptors.get(i);
                interceptor.process(request, context);
            }
        }
    }

    private final void $$robo$$org_apache_http_protocol_BasicHttpProcessor$process(HttpResponse response, HttpContext context) throws IOException, HttpException {
        if (this.responseInterceptors != null) {
            for (int i = 0; i < this.responseInterceptors.size(); ++i) {
                HttpResponseInterceptor interceptor = (HttpResponseInterceptor)this.responseInterceptors.get(i);
                interceptor.process(response, context);
            }
        }
    }

    private final void $$robo$$org_apache_http_protocol_BasicHttpProcessor$copyInterceptors(BasicHttpProcessor target) {
        if (this.requestInterceptors != null) {
            target.requestInterceptors = new ArrayList(this.requestInterceptors);
        }
        if (this.responseInterceptors != null) {
            target.responseInterceptors = new ArrayList(this.responseInterceptors);
        }
    }

    private final BasicHttpProcessor $$robo$$org_apache_http_protocol_BasicHttpProcessor$copy() {
        BasicHttpProcessor clone = new BasicHttpProcessor();
        this.copyInterceptors(clone);
        return clone;
    }

    private final Object $$robo$$org_apache_http_protocol_BasicHttpProcessor$clone() throws CloneNotSupportedException {
        BasicHttpProcessor clone = (BasicHttpProcessor)super.clone();
        this.copyInterceptors(clone);
        return clone;
    }

    private void __constructor__() {
        this.$$robo$$org_apache_http_protocol_BasicHttpProcessor$__constructor__();
    }

    public BasicHttpProcessor() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_protocol_BasicHttpProcessor$__constructor__(), 0, this);
    }

    @Override
    public void addRequestInterceptor(HttpRequestInterceptor httpRequestInterceptor) {
        InvokeDynamicSupport.bootstrap("addRequestInterceptor", $$robo$$org_apache_http_protocol_BasicHttpProcessor$addRequestInterceptor(org.apache.http.HttpRequestInterceptor ), 0, this, httpRequestInterceptor);
    }

    @Override
    public void addRequestInterceptor(HttpRequestInterceptor httpRequestInterceptor, int n) {
        InvokeDynamicSupport.bootstrap("addRequestInterceptor", $$robo$$org_apache_http_protocol_BasicHttpProcessor$addRequestInterceptor(org.apache.http.HttpRequestInterceptor int ), 0, this, httpRequestInterceptor, n);
    }

    @Override
    public void addResponseInterceptor(HttpResponseInterceptor httpResponseInterceptor, int n) {
        InvokeDynamicSupport.bootstrap("addResponseInterceptor", $$robo$$org_apache_http_protocol_BasicHttpProcessor$addResponseInterceptor(org.apache.http.HttpResponseInterceptor int ), 0, this, httpResponseInterceptor, n);
    }

    @Override
    public void removeRequestInterceptorByClass(Class clazz) {
        InvokeDynamicSupport.bootstrap("removeRequestInterceptorByClass", $$robo$$org_apache_http_protocol_BasicHttpProcessor$removeRequestInterceptorByClass(java.lang.Class ), 0, this, clazz);
    }

    @Override
    public void removeResponseInterceptorByClass(Class clazz) {
        InvokeDynamicSupport.bootstrap("removeResponseInterceptorByClass", $$robo$$org_apache_http_protocol_BasicHttpProcessor$removeResponseInterceptorByClass(java.lang.Class ), 0, this, clazz);
    }

    public void addInterceptor(HttpRequestInterceptor httpRequestInterceptor) {
        InvokeDynamicSupport.bootstrap("addInterceptor", $$robo$$org_apache_http_protocol_BasicHttpProcessor$addInterceptor(org.apache.http.HttpRequestInterceptor ), 0, this, httpRequestInterceptor);
    }

    public void addInterceptor(HttpRequestInterceptor httpRequestInterceptor, int n) {
        InvokeDynamicSupport.bootstrap("addInterceptor", $$robo$$org_apache_http_protocol_BasicHttpProcessor$addInterceptor(org.apache.http.HttpRequestInterceptor int ), 0, this, httpRequestInterceptor, n);
    }

    @Override
    public int getRequestInterceptorCount() {
        return (int)InvokeDynamicSupport.bootstrap("getRequestInterceptorCount", $$robo$$org_apache_http_protocol_BasicHttpProcessor$getRequestInterceptorCount(), 0, this);
    }

    @Override
    public HttpRequestInterceptor getRequestInterceptor(int n) {
        return InvokeDynamicSupport.bootstrap("getRequestInterceptor", $$robo$$org_apache_http_protocol_BasicHttpProcessor$getRequestInterceptor(int ), 0, this, n);
    }

    @Override
    public void clearRequestInterceptors() {
        InvokeDynamicSupport.bootstrap("clearRequestInterceptors", $$robo$$org_apache_http_protocol_BasicHttpProcessor$clearRequestInterceptors(), 0, this);
    }

    @Override
    public void addResponseInterceptor(HttpResponseInterceptor httpResponseInterceptor) {
        InvokeDynamicSupport.bootstrap("addResponseInterceptor", $$robo$$org_apache_http_protocol_BasicHttpProcessor$addResponseInterceptor(org.apache.http.HttpResponseInterceptor ), 0, this, httpResponseInterceptor);
    }

    public void addInterceptor(HttpResponseInterceptor httpResponseInterceptor) {
        InvokeDynamicSupport.bootstrap("addInterceptor", $$robo$$org_apache_http_protocol_BasicHttpProcessor$addInterceptor(org.apache.http.HttpResponseInterceptor ), 0, this, httpResponseInterceptor);
    }

    public void addInterceptor(HttpResponseInterceptor httpResponseInterceptor, int n) {
        InvokeDynamicSupport.bootstrap("addInterceptor", $$robo$$org_apache_http_protocol_BasicHttpProcessor$addInterceptor(org.apache.http.HttpResponseInterceptor int ), 0, this, httpResponseInterceptor, n);
    }

    @Override
    public int getResponseInterceptorCount() {
        return (int)InvokeDynamicSupport.bootstrap("getResponseInterceptorCount", $$robo$$org_apache_http_protocol_BasicHttpProcessor$getResponseInterceptorCount(), 0, this);
    }

    @Override
    public HttpResponseInterceptor getResponseInterceptor(int n) {
        return InvokeDynamicSupport.bootstrap("getResponseInterceptor", $$robo$$org_apache_http_protocol_BasicHttpProcessor$getResponseInterceptor(int ), 0, this, n);
    }

    @Override
    public void clearResponseInterceptors() {
        InvokeDynamicSupport.bootstrap("clearResponseInterceptors", $$robo$$org_apache_http_protocol_BasicHttpProcessor$clearResponseInterceptors(), 0, this);
    }

    @Override
    public void setInterceptors(List list) {
        InvokeDynamicSupport.bootstrap("setInterceptors", $$robo$$org_apache_http_protocol_BasicHttpProcessor$setInterceptors(java.util.List ), 0, this, list);
    }

    public void clearInterceptors() {
        InvokeDynamicSupport.bootstrap("clearInterceptors", $$robo$$org_apache_http_protocol_BasicHttpProcessor$clearInterceptors(), 0, this);
    }

    @Override
    public void process(HttpRequest httpRequest, HttpContext httpContext) throws IOException, HttpException {
        InvokeDynamicSupport.bootstrap("process", $$robo$$org_apache_http_protocol_BasicHttpProcessor$process(org.apache.http.HttpRequest org.apache.http.protocol.HttpContext ), 0, this, httpRequest, httpContext);
    }

    @Override
    public void process(HttpResponse httpResponse, HttpContext httpContext) throws IOException, HttpException {
        InvokeDynamicSupport.bootstrap("process", $$robo$$org_apache_http_protocol_BasicHttpProcessor$process(org.apache.http.HttpResponse org.apache.http.protocol.HttpContext ), 0, this, httpResponse, httpContext);
    }

    protected void copyInterceptors(BasicHttpProcessor basicHttpProcessor) {
        InvokeDynamicSupport.bootstrap("copyInterceptors", $$robo$$org_apache_http_protocol_BasicHttpProcessor$copyInterceptors(org.apache.http.protocol.BasicHttpProcessor ), 0, this, basicHttpProcessor);
    }

    public BasicHttpProcessor copy() {
        return InvokeDynamicSupport.bootstrap("copy", $$robo$$org_apache_http_protocol_BasicHttpProcessor$copy(), 0, this);
    }

    public Object clone() throws CloneNotSupportedException {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$org_apache_http_protocol_BasicHttpProcessor$clone(), 0, this);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BasicHttpProcessor)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

