/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.protocol;

import java.io.IOException;
import java.net.ProtocolException;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class HttpRequestExecutor
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;

    private void $$robo$$org_apache_http_protocol_HttpRequestExecutor$__constructor__() {
    }

    private final boolean $$robo$$org_apache_http_protocol_HttpRequestExecutor$canResponseHaveBody(HttpRequest request, HttpResponse response) {
        if ("HEAD".equalsIgnoreCase(request.getRequestLine().getMethod())) {
            return false;
        }
        int status = response.getStatusLine().getStatusCode();
        return status >= 200 && status != 204 && status != 304 && status != 205;
    }

    private final HttpResponse $$robo$$org_apache_http_protocol_HttpRequestExecutor$execute(HttpRequest request, HttpClientConnection conn, HttpContext context) throws IOException, HttpException {
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (conn == null) {
            throw new IllegalArgumentException("Client connection may not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        try {
            HttpResponse response = this.doSendRequest(request, conn, context);
            if (response == null) {
                response = this.doReceiveResponse(request, conn, context);
            }
            return response;
        }
        catch (IOException ex) {
            conn.close();
            throw ex;
        }
        catch (HttpException ex) {
            conn.close();
            throw ex;
        }
        catch (RuntimeException ex) {
            conn.close();
            throw ex;
        }
    }

    private final void $$robo$$org_apache_http_protocol_HttpRequestExecutor$preProcess(HttpRequest request, HttpProcessor processor, HttpContext context) throws HttpException, IOException {
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("HTTP processor may not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        processor.process(request, context);
    }

    private final HttpResponse $$robo$$org_apache_http_protocol_HttpRequestExecutor$doSendRequest(HttpRequest request, HttpClientConnection conn, HttpContext context) throws IOException, HttpException {
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (conn == null) {
            throw new IllegalArgumentException("HTTP connection may not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        HttpResponse response = null;
        context.setAttribute("http.request_sent", Boolean.FALSE);
        conn.sendRequestHeader(request);
        if (request instanceof HttpEntityEnclosingRequest) {
            boolean sendentity = true;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            if (((HttpEntityEnclosingRequest)request).expectContinue() && !ver.lessEquals(HttpVersion.HTTP_1_0)) {
                conn.flush();
                int tms = request.getParams().getIntParameter("http.protocol.wait-for-continue", 2000);
                if (conn.isResponseAvailable(tms)) {
                    int status;
                    response = conn.receiveResponseHeader();
                    if (this.canResponseHaveBody(request, response)) {
                        conn.receiveResponseEntity(response);
                    }
                    if ((status = response.getStatusLine().getStatusCode()) < 200) {
                        if (status != 100) {
                            throw new ProtocolException("Unexpected response: " + response.getStatusLine());
                        }
                        response = null;
                    } else {
                        sendentity = false;
                    }
                }
            }
            if (sendentity) {
                conn.sendRequestEntity((HttpEntityEnclosingRequest)request);
            }
        }
        conn.flush();
        context.setAttribute("http.request_sent", Boolean.TRUE);
        return response;
    }

    private final HttpResponse $$robo$$org_apache_http_protocol_HttpRequestExecutor$doReceiveResponse(HttpRequest request, HttpClientConnection conn, HttpContext context) throws HttpException, IOException {
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (conn == null) {
            throw new IllegalArgumentException("HTTP connection may not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        HttpResponse response = null;
        int statuscode = 0;
        while (response == null || statuscode < 200) {
            response = conn.receiveResponseHeader();
            if (this.canResponseHaveBody(request, response)) {
                conn.receiveResponseEntity(response);
            }
            statuscode = response.getStatusLine().getStatusCode();
        }
        return response;
    }

    private final void $$robo$$org_apache_http_protocol_HttpRequestExecutor$postProcess(HttpResponse response, HttpProcessor processor, HttpContext context) throws HttpException, IOException {
        if (response == null) {
            throw new IllegalArgumentException("HTTP response may not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("HTTP processor may not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        processor.process(response, context);
    }

    private void __constructor__() {
        this.$$robo$$org_apache_http_protocol_HttpRequestExecutor$__constructor__();
    }

    public HttpRequestExecutor() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_protocol_HttpRequestExecutor$__constructor__(), 0, this);
    }

    protected boolean canResponseHaveBody(HttpRequest httpRequest, HttpResponse httpResponse) {
        return (boolean)InvokeDynamicSupport.bootstrap("canResponseHaveBody", $$robo$$org_apache_http_protocol_HttpRequestExecutor$canResponseHaveBody(org.apache.http.HttpRequest org.apache.http.HttpResponse ), 0, this, httpRequest, httpResponse);
    }

    public HttpResponse execute(HttpRequest httpRequest, HttpClientConnection httpClientConnection, HttpContext httpContext) throws IOException, HttpException {
        return InvokeDynamicSupport.bootstrap("execute", $$robo$$org_apache_http_protocol_HttpRequestExecutor$execute(org.apache.http.HttpRequest org.apache.http.HttpClientConnection org.apache.http.protocol.HttpContext ), 0, this, httpRequest, httpClientConnection, httpContext);
    }

    public void preProcess(HttpRequest httpRequest, HttpProcessor httpProcessor, HttpContext httpContext) throws HttpException, IOException {
        InvokeDynamicSupport.bootstrap("preProcess", $$robo$$org_apache_http_protocol_HttpRequestExecutor$preProcess(org.apache.http.HttpRequest org.apache.http.protocol.HttpProcessor org.apache.http.protocol.HttpContext ), 0, this, httpRequest, httpProcessor, httpContext);
    }

    protected HttpResponse doSendRequest(HttpRequest httpRequest, HttpClientConnection httpClientConnection, HttpContext httpContext) throws IOException, HttpException {
        return InvokeDynamicSupport.bootstrap("doSendRequest", $$robo$$org_apache_http_protocol_HttpRequestExecutor$doSendRequest(org.apache.http.HttpRequest org.apache.http.HttpClientConnection org.apache.http.protocol.HttpContext ), 0, this, httpRequest, httpClientConnection, httpContext);
    }

    protected HttpResponse doReceiveResponse(HttpRequest httpRequest, HttpClientConnection httpClientConnection, HttpContext httpContext) throws HttpException, IOException {
        return InvokeDynamicSupport.bootstrap("doReceiveResponse", $$robo$$org_apache_http_protocol_HttpRequestExecutor$doReceiveResponse(org.apache.http.HttpRequest org.apache.http.HttpClientConnection org.apache.http.protocol.HttpContext ), 0, this, httpRequest, httpClientConnection, httpContext);
    }

    public void postProcess(HttpResponse httpResponse, HttpProcessor httpProcessor, HttpContext httpContext) throws HttpException, IOException {
        InvokeDynamicSupport.bootstrap("postProcess", $$robo$$org_apache_http_protocol_HttpRequestExecutor$postProcess(org.apache.http.HttpResponse org.apache.http.protocol.HttpProcessor org.apache.http.protocol.HttpContext ), 0, this, httpResponse, httpProcessor, httpContext);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (HttpRequestExecutor)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

