/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.protocol;

import java.io.IOException;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpServerConnection;
import org.apache.http.HttpVersion;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.ProtocolException;
import org.apache.http.ProtocolVersion;
import org.apache.http.UnsupportedHttpVersionException;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.params.DefaultedHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpExpectationVerifier;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.HttpRequestHandlerResolver;
import org.apache.http.util.EncodingUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class HttpService
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private HttpParams params;
    private HttpProcessor processor;
    private HttpRequestHandlerResolver handlerResolver;
    private ConnectionReuseStrategy connStrategy;
    private HttpResponseFactory responseFactory;
    private HttpExpectationVerifier expectationVerifier;

    private void $$robo$$org_apache_http_protocol_HttpService$__constructor__(HttpProcessor proc, ConnectionReuseStrategy connStrategy, HttpResponseFactory responseFactory) {
        this.params = null;
        this.processor = null;
        this.handlerResolver = null;
        this.connStrategy = null;
        this.responseFactory = null;
        this.expectationVerifier = null;
        this.setHttpProcessor(proc);
        this.setConnReuseStrategy(connStrategy);
        this.setResponseFactory(responseFactory);
    }

    private final void $$robo$$org_apache_http_protocol_HttpService$setHttpProcessor(HttpProcessor processor) {
        if (processor == null) {
            throw new IllegalArgumentException("HTTP processor may not be null.");
        }
        this.processor = processor;
    }

    private final void $$robo$$org_apache_http_protocol_HttpService$setConnReuseStrategy(ConnectionReuseStrategy connStrategy) {
        if (connStrategy == null) {
            throw new IllegalArgumentException("Connection reuse strategy may not be null");
        }
        this.connStrategy = connStrategy;
    }

    private final void $$robo$$org_apache_http_protocol_HttpService$setResponseFactory(HttpResponseFactory responseFactory) {
        if (responseFactory == null) {
            throw new IllegalArgumentException("Response factory may not be null");
        }
        this.responseFactory = responseFactory;
    }

    private final void $$robo$$org_apache_http_protocol_HttpService$setHandlerResolver(HttpRequestHandlerResolver handlerResolver) {
        this.handlerResolver = handlerResolver;
    }

    private final void $$robo$$org_apache_http_protocol_HttpService$setExpectationVerifier(HttpExpectationVerifier expectationVerifier) {
        this.expectationVerifier = expectationVerifier;
    }

    private final HttpParams $$robo$$org_apache_http_protocol_HttpService$getParams() {
        return this.params;
    }

    private final void $$robo$$org_apache_http_protocol_HttpService$setParams(HttpParams params) {
        this.params = params;
    }

    private final void $$robo$$org_apache_http_protocol_HttpService$handleRequest(HttpServerConnection conn, HttpContext context) throws IOException, HttpException {
        context.setAttribute("http.connection", conn);
        HttpResponse response = null;
        try {
            HttpEntity entity;
            HttpRequest request = conn.receiveRequestHeader();
            request.setParams(new DefaultedHttpParams(request.getParams(), this.params));
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            if (!ver.lessEquals(HttpVersion.HTTP_1_1)) {
                ver = HttpVersion.HTTP_1_1;
            }
            if (request instanceof HttpEntityEnclosingRequest) {
                if (((HttpEntityEnclosingRequest)request).expectContinue()) {
                    response = this.responseFactory.newHttpResponse(ver, 100, context);
                    response.setParams(new DefaultedHttpParams(response.getParams(), this.params));
                    if (this.expectationVerifier != null) {
                        try {
                            this.expectationVerifier.verify(request, response, context);
                        }
                        catch (HttpException ex) {
                            response = this.responseFactory.newHttpResponse(HttpVersion.HTTP_1_0, 500, context);
                            response.setParams(new DefaultedHttpParams(response.getParams(), this.params));
                            this.handleException(ex, response);
                        }
                    }
                    if (response.getStatusLine().getStatusCode() < 200) {
                        conn.sendResponseHeader(response);
                        conn.flush();
                        response = null;
                        conn.receiveRequestEntity((HttpEntityEnclosingRequest)request);
                    }
                } else {
                    conn.receiveRequestEntity((HttpEntityEnclosingRequest)request);
                }
            }
            if (response == null) {
                response = this.responseFactory.newHttpResponse(ver, 200, context);
                response.setParams(new DefaultedHttpParams(response.getParams(), this.params));
                context.setAttribute("http.request", request);
                context.setAttribute("http.response", response);
                this.processor.process(request, context);
                this.doService(request, response, context);
            }
            if (request instanceof HttpEntityEnclosingRequest && (entity = ((HttpEntityEnclosingRequest)request).getEntity()) != null) {
                entity.consumeContent();
            }
        }
        catch (HttpException ex) {
            response = this.responseFactory.newHttpResponse(HttpVersion.HTTP_1_0, 500, context);
            response.setParams(new DefaultedHttpParams(response.getParams(), this.params));
            this.handleException(ex, response);
        }
        this.processor.process(response, context);
        conn.sendResponseHeader(response);
        conn.sendResponseEntity(response);
        conn.flush();
        if (!this.connStrategy.keepAlive(response, context)) {
            conn.close();
        }
    }

    private final void $$robo$$org_apache_http_protocol_HttpService$handleException(HttpException ex, HttpResponse response) {
        if (ex instanceof MethodNotSupportedException) {
            response.setStatusCode(501);
        } else if (ex instanceof UnsupportedHttpVersionException) {
            response.setStatusCode(505);
        } else if (ex instanceof ProtocolException) {
            response.setStatusCode(400);
        } else {
            response.setStatusCode(500);
        }
        byte[] msg = EncodingUtils.getAsciiBytes(ex.getMessage());
        ByteArrayEntity entity = new ByteArrayEntity(msg);
        entity.setContentType("text/plain; charset=US-ASCII");
        response.setEntity(entity);
    }

    private final void $$robo$$org_apache_http_protocol_HttpService$doService(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        HttpRequestHandler handler = null;
        if (this.handlerResolver != null) {
            String requestURI = request.getRequestLine().getUri();
            handler = this.handlerResolver.lookup(requestURI);
        }
        if (handler != null) {
            handler.handle(request, response, context);
        } else {
            response.setStatusCode(501);
        }
    }

    private void __constructor__(HttpProcessor httpProcessor, ConnectionReuseStrategy connectionReuseStrategy, HttpResponseFactory httpResponseFactory) {
        this.$$robo$$org_apache_http_protocol_HttpService$__constructor__(httpProcessor, connectionReuseStrategy, httpResponseFactory);
    }

    public HttpService(HttpProcessor httpProcessor, ConnectionReuseStrategy connectionReuseStrategy, HttpResponseFactory httpResponseFactory) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_protocol_HttpService$__constructor__(org.apache.http.protocol.HttpProcessor org.apache.http.ConnectionReuseStrategy org.apache.http.HttpResponseFactory ), 0, this, httpProcessor, connectionReuseStrategy, httpResponseFactory);
    }

    public void setHttpProcessor(HttpProcessor httpProcessor) {
        InvokeDynamicSupport.bootstrap("setHttpProcessor", $$robo$$org_apache_http_protocol_HttpService$setHttpProcessor(org.apache.http.protocol.HttpProcessor ), 0, this, httpProcessor);
    }

    public void setConnReuseStrategy(ConnectionReuseStrategy connectionReuseStrategy) {
        InvokeDynamicSupport.bootstrap("setConnReuseStrategy", $$robo$$org_apache_http_protocol_HttpService$setConnReuseStrategy(org.apache.http.ConnectionReuseStrategy ), 0, this, connectionReuseStrategy);
    }

    public void setResponseFactory(HttpResponseFactory httpResponseFactory) {
        InvokeDynamicSupport.bootstrap("setResponseFactory", $$robo$$org_apache_http_protocol_HttpService$setResponseFactory(org.apache.http.HttpResponseFactory ), 0, this, httpResponseFactory);
    }

    public void setHandlerResolver(HttpRequestHandlerResolver httpRequestHandlerResolver) {
        InvokeDynamicSupport.bootstrap("setHandlerResolver", $$robo$$org_apache_http_protocol_HttpService$setHandlerResolver(org.apache.http.protocol.HttpRequestHandlerResolver ), 0, this, httpRequestHandlerResolver);
    }

    public void setExpectationVerifier(HttpExpectationVerifier httpExpectationVerifier) {
        InvokeDynamicSupport.bootstrap("setExpectationVerifier", $$robo$$org_apache_http_protocol_HttpService$setExpectationVerifier(org.apache.http.protocol.HttpExpectationVerifier ), 0, this, httpExpectationVerifier);
    }

    public HttpParams getParams() {
        return InvokeDynamicSupport.bootstrap("getParams", $$robo$$org_apache_http_protocol_HttpService$getParams(), 0, this);
    }

    public void setParams(HttpParams httpParams) {
        InvokeDynamicSupport.bootstrap("setParams", $$robo$$org_apache_http_protocol_HttpService$setParams(org.apache.http.params.HttpParams ), 0, this, httpParams);
    }

    public void handleRequest(HttpServerConnection httpServerConnection, HttpContext httpContext) throws IOException, HttpException {
        InvokeDynamicSupport.bootstrap("handleRequest", $$robo$$org_apache_http_protocol_HttpService$handleRequest(org.apache.http.HttpServerConnection org.apache.http.protocol.HttpContext ), 0, this, httpServerConnection, httpContext);
    }

    protected void handleException(HttpException httpException, HttpResponse httpResponse) {
        InvokeDynamicSupport.bootstrap("handleException", $$robo$$org_apache_http_protocol_HttpService$handleException(org.apache.http.HttpException org.apache.http.HttpResponse ), 0, this, httpException, httpResponse);
    }

    protected void doService(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
        InvokeDynamicSupport.bootstrap("doService", $$robo$$org_apache_http_protocol_HttpService$doService(org.apache.http.HttpRequest org.apache.http.HttpResponse org.apache.http.protocol.HttpContext ), 0, this, httpRequest, httpResponse, httpContext);
    }

    public /* synthetic */ HttpService() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (HttpService)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

