/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.util;

import com.google.errorprone.annotations.DoNotMock;
import org.apache.http.util.CharArrayBuffer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class ByteArrayBuffer
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private byte[] buffer;
    private int len;

    private void $$robo$$org_apache_http_util_ByteArrayBuffer$__constructor__(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Buffer capacity may not be negative");
        }
        this.buffer = new byte[capacity];
    }

    private final void $$robo$$org_apache_http_util_ByteArrayBuffer$expand(int newlen) {
        byte[] newbuffer = new byte[Math.max(this.buffer.length << 1, newlen)];
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])this.buffer, (int)0, (byte[])newbuffer, (int)0, (int)this.len);
        this.buffer = newbuffer;
    }

    private final void $$robo$$org_apache_http_util_ByteArrayBuffer$append(byte[] b, int off, int len) {
        if (b == null) {
            return;
        }
        if (off < 0 || off > b.length || len < 0 || off + len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int newlen = this.len + len;
        if (newlen > this.buffer.length) {
            this.expand(newlen);
        }
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])b, (int)off, (byte[])this.buffer, (int)this.len, (int)len);
        this.len = newlen;
    }

    private final void $$robo$$org_apache_http_util_ByteArrayBuffer$append(int b) {
        int newlen = this.len + 1;
        if (newlen > this.buffer.length) {
            this.expand(newlen);
        }
        this.buffer[this.len] = (byte)b;
        this.len = newlen;
    }

    private final void $$robo$$org_apache_http_util_ByteArrayBuffer$append(char[] b, int off, int len) {
        if (b == null) {
            return;
        }
        if (off < 0 || off > b.length || len < 0 || off + len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int oldlen = this.len;
        int newlen = oldlen + len;
        if (newlen > this.buffer.length) {
            this.expand(newlen);
        }
        int i1 = off;
        for (int i2 = oldlen; i2 < newlen; ++i2) {
            this.buffer[i2] = (byte)b[i1];
            ++i1;
        }
        this.len = newlen;
    }

    private final void $$robo$$org_apache_http_util_ByteArrayBuffer$append(CharArrayBuffer b, int off, int len) {
        if (b == null) {
            return;
        }
        this.append(b.buffer(), off, len);
    }

    private final void $$robo$$org_apache_http_util_ByteArrayBuffer$clear() {
        this.len = 0;
    }

    private final byte[] $$robo$$org_apache_http_util_ByteArrayBuffer$toByteArray() {
        byte[] b = new byte[this.len];
        if (this.len > 0) {
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])this.buffer, (int)0, (byte[])b, (int)0, (int)this.len);
        }
        return b;
    }

    private final int $$robo$$org_apache_http_util_ByteArrayBuffer$byteAt(int i) {
        return this.buffer[i];
    }

    private final int $$robo$$org_apache_http_util_ByteArrayBuffer$capacity() {
        return this.buffer.length;
    }

    private final int $$robo$$org_apache_http_util_ByteArrayBuffer$length() {
        return this.len;
    }

    private final byte[] $$robo$$org_apache_http_util_ByteArrayBuffer$buffer() {
        return this.buffer;
    }

    private final void $$robo$$org_apache_http_util_ByteArrayBuffer$setLength(int len) {
        if (len < 0 || len > this.buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        this.len = len;
    }

    private final boolean $$robo$$org_apache_http_util_ByteArrayBuffer$isEmpty() {
        return this.len == 0;
    }

    private final boolean $$robo$$org_apache_http_util_ByteArrayBuffer$isFull() {
        return this.len == this.buffer.length;
    }

    private void __constructor__(int n) {
        this.$$robo$$org_apache_http_util_ByteArrayBuffer$__constructor__(n);
    }

    public ByteArrayBuffer(int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_util_ByteArrayBuffer$__constructor__(int ), 0, this, n);
    }

    private void expand(int n) {
        InvokeDynamicSupport.bootstrap("expand", $$robo$$org_apache_http_util_ByteArrayBuffer$expand(int ), 0, this, n);
    }

    public void append(byte[] byArray, int n, int n2) {
        InvokeDynamicSupport.bootstrap("append", $$robo$$org_apache_http_util_ByteArrayBuffer$append(byte[] int int ), 0, this, byArray, n, n2);
    }

    public void append(int n) {
        InvokeDynamicSupport.bootstrap("append", $$robo$$org_apache_http_util_ByteArrayBuffer$append(int ), 0, this, n);
    }

    public void append(char[] cArray, int n, int n2) {
        InvokeDynamicSupport.bootstrap("append", $$robo$$org_apache_http_util_ByteArrayBuffer$append(char[] int int ), 0, this, cArray, n, n2);
    }

    public void append(CharArrayBuffer charArrayBuffer, int n, int n2) {
        InvokeDynamicSupport.bootstrap("append", $$robo$$org_apache_http_util_ByteArrayBuffer$append(org.apache.http.util.CharArrayBuffer int int ), 0, this, charArrayBuffer, n, n2);
    }

    public void clear() {
        InvokeDynamicSupport.bootstrap("clear", $$robo$$org_apache_http_util_ByteArrayBuffer$clear(), 0, this);
    }

    public byte[] toByteArray() {
        return InvokeDynamicSupport.bootstrap("toByteArray", $$robo$$org_apache_http_util_ByteArrayBuffer$toByteArray(), 0, this);
    }

    public int byteAt(int n) {
        return (int)InvokeDynamicSupport.bootstrap("byteAt", $$robo$$org_apache_http_util_ByteArrayBuffer$byteAt(int ), 0, this, n);
    }

    public int capacity() {
        return (int)InvokeDynamicSupport.bootstrap("capacity", $$robo$$org_apache_http_util_ByteArrayBuffer$capacity(), 0, this);
    }

    public int length() {
        return (int)InvokeDynamicSupport.bootstrap("length", $$robo$$org_apache_http_util_ByteArrayBuffer$length(), 0, this);
    }

    public byte[] buffer() {
        return InvokeDynamicSupport.bootstrap("buffer", $$robo$$org_apache_http_util_ByteArrayBuffer$buffer(), 0, this);
    }

    public void setLength(int n) {
        InvokeDynamicSupport.bootstrap("setLength", $$robo$$org_apache_http_util_ByteArrayBuffer$setLength(int ), 0, this, n);
    }

    public boolean isEmpty() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEmpty", $$robo$$org_apache_http_util_ByteArrayBuffer$isEmpty(), 0, this);
    }

    public boolean isFull() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFull", $$robo$$org_apache_http_util_ByteArrayBuffer$isFull(), 0, this);
    }

    public /* synthetic */ ByteArrayBuffer() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ByteArrayBuffer)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

