/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.util;

import com.google.errorprone.annotations.DoNotMock;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.ByteArrayBuffer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class CharArrayBuffer
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private char[] buffer;
    private int len;

    private void $$robo$$org_apache_http_util_CharArrayBuffer$__constructor__(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Buffer capacity may not be negative");
        }
        this.buffer = new char[capacity];
    }

    private final void $$robo$$org_apache_http_util_CharArrayBuffer$expand(int newlen) {
        char[] newbuffer = new char[Math.max(this.buffer.length << 1, newlen)];
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (char[])this.buffer, (int)0, (char[])newbuffer, (int)0, (int)this.len);
        this.buffer = newbuffer;
    }

    private final void $$robo$$org_apache_http_util_CharArrayBuffer$append(char[] b, int off, int len) {
        if (b == null) {
            return;
        }
        if (off < 0 || off > b.length || len < 0 || off + len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int newlen = this.len + len;
        if (newlen > this.buffer.length) {
            this.expand(newlen);
        }
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (char[])b, (int)off, (char[])this.buffer, (int)this.len, (int)len);
        this.len = newlen;
    }

    private final void $$robo$$org_apache_http_util_CharArrayBuffer$append(String str) {
        int strlen;
        int newlen;
        if (str == null) {
            str = "null";
        }
        if ((newlen = this.len + (strlen = str.length())) > this.buffer.length) {
            this.expand(newlen);
        }
        str.getChars(0, strlen, this.buffer, this.len);
        this.len = newlen;
    }

    private final void $$robo$$org_apache_http_util_CharArrayBuffer$append(CharArrayBuffer b, int off, int len) {
        if (b == null) {
            return;
        }
        this.append(b.buffer, off, len);
    }

    private final void $$robo$$org_apache_http_util_CharArrayBuffer$append(CharArrayBuffer b) {
        if (b == null) {
            return;
        }
        this.append(b.buffer, 0, b.len);
    }

    private final void $$robo$$org_apache_http_util_CharArrayBuffer$append(char ch) {
        int newlen = this.len + 1;
        if (newlen > this.buffer.length) {
            this.expand(newlen);
        }
        this.buffer[this.len] = ch;
        this.len = newlen;
    }

    private final void $$robo$$org_apache_http_util_CharArrayBuffer$append(byte[] b, int off, int len) {
        if (b == null) {
            return;
        }
        if (off < 0 || off > b.length || len < 0 || off + len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int oldlen = this.len;
        int newlen = oldlen + len;
        if (newlen > this.buffer.length) {
            this.expand(newlen);
        }
        int i1 = off;
        for (int i2 = oldlen; i2 < newlen; ++i2) {
            int ch = b[i1];
            if (ch < 0) {
                ch = 256 + ch;
            }
            this.buffer[i2] = (char)ch;
            ++i1;
        }
        this.len = newlen;
    }

    private final void $$robo$$org_apache_http_util_CharArrayBuffer$append(ByteArrayBuffer b, int off, int len) {
        if (b == null) {
            return;
        }
        this.append(b.buffer(), off, len);
    }

    private final void $$robo$$org_apache_http_util_CharArrayBuffer$append(Object obj) {
        this.append(String.valueOf(obj));
    }

    private final void $$robo$$org_apache_http_util_CharArrayBuffer$clear() {
        this.len = 0;
    }

    private final char[] $$robo$$org_apache_http_util_CharArrayBuffer$toCharArray() {
        char[] b = new char[this.len];
        if (this.len > 0) {
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (char[])this.buffer, (int)0, (char[])b, (int)0, (int)this.len);
        }
        return b;
    }

    private final char $$robo$$org_apache_http_util_CharArrayBuffer$charAt(int i) {
        return this.buffer[i];
    }

    private final char[] $$robo$$org_apache_http_util_CharArrayBuffer$buffer() {
        return this.buffer;
    }

    private final int $$robo$$org_apache_http_util_CharArrayBuffer$capacity() {
        return this.buffer.length;
    }

    private final int $$robo$$org_apache_http_util_CharArrayBuffer$length() {
        return this.len;
    }

    private final void $$robo$$org_apache_http_util_CharArrayBuffer$ensureCapacity(int required) {
        int available = this.buffer.length - this.len;
        if (required > available) {
            this.expand(this.len + required);
        }
    }

    private final void $$robo$$org_apache_http_util_CharArrayBuffer$setLength(int len) {
        if (len < 0 || len > this.buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        this.len = len;
    }

    private final boolean $$robo$$org_apache_http_util_CharArrayBuffer$isEmpty() {
        return this.len == 0;
    }

    private final boolean $$robo$$org_apache_http_util_CharArrayBuffer$isFull() {
        return this.len == this.buffer.length;
    }

    private final int $$robo$$org_apache_http_util_CharArrayBuffer$indexOf(int ch, int beginIndex, int endIndex) {
        if (beginIndex < 0) {
            beginIndex = 0;
        }
        if (endIndex > this.len) {
            endIndex = this.len;
        }
        if (beginIndex > endIndex) {
            return -1;
        }
        for (int i = beginIndex; i < endIndex; ++i) {
            if (this.buffer[i] != ch) continue;
            return i;
        }
        return -1;
    }

    private final int $$robo$$org_apache_http_util_CharArrayBuffer$indexOf(int ch) {
        return this.indexOf(ch, 0, this.len);
    }

    private final String $$robo$$org_apache_http_util_CharArrayBuffer$substring(int beginIndex, int endIndex) {
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (endIndex > this.len) {
            throw new IndexOutOfBoundsException();
        }
        if (beginIndex > endIndex) {
            throw new IndexOutOfBoundsException();
        }
        return new String(this.buffer, beginIndex, endIndex - beginIndex);
    }

    private final String $$robo$$org_apache_http_util_CharArrayBuffer$substringTrimmed(int beginIndex, int endIndex) {
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (endIndex > this.len) {
            throw new IndexOutOfBoundsException();
        }
        if (beginIndex > endIndex) {
            throw new IndexOutOfBoundsException();
        }
        while (beginIndex < endIndex && HTTP.isWhitespace(this.buffer[beginIndex])) {
            ++beginIndex;
        }
        while (endIndex > beginIndex && HTTP.isWhitespace(this.buffer[endIndex - 1])) {
            --endIndex;
        }
        return new String(this.buffer, beginIndex, endIndex - beginIndex);
    }

    private final String $$robo$$org_apache_http_util_CharArrayBuffer$toString() {
        return new String(this.buffer, 0, this.len);
    }

    private void __constructor__(int n) {
        this.$$robo$$org_apache_http_util_CharArrayBuffer$__constructor__(n);
    }

    public CharArrayBuffer(int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_util_CharArrayBuffer$__constructor__(int ), 0, this, n);
    }

    private void expand(int n) {
        InvokeDynamicSupport.bootstrap("expand", $$robo$$org_apache_http_util_CharArrayBuffer$expand(int ), 0, this, n);
    }

    public void append(char[] cArray, int n, int n2) {
        InvokeDynamicSupport.bootstrap("append", $$robo$$org_apache_http_util_CharArrayBuffer$append(char[] int int ), 0, this, cArray, n, n2);
    }

    public void append(String string2) {
        InvokeDynamicSupport.bootstrap("append", $$robo$$org_apache_http_util_CharArrayBuffer$append(java.lang.String ), 0, this, string2);
    }

    public void append(CharArrayBuffer charArrayBuffer, int n, int n2) {
        InvokeDynamicSupport.bootstrap("append", $$robo$$org_apache_http_util_CharArrayBuffer$append(org.apache.http.util.CharArrayBuffer int int ), 0, this, charArrayBuffer, n, n2);
    }

    public void append(CharArrayBuffer charArrayBuffer) {
        InvokeDynamicSupport.bootstrap("append", $$robo$$org_apache_http_util_CharArrayBuffer$append(org.apache.http.util.CharArrayBuffer ), 0, this, charArrayBuffer);
    }

    public void append(char c) {
        InvokeDynamicSupport.bootstrap("append", $$robo$$org_apache_http_util_CharArrayBuffer$append(char ), 0, this, c);
    }

    public void append(byte[] byArray, int n, int n2) {
        InvokeDynamicSupport.bootstrap("append", $$robo$$org_apache_http_util_CharArrayBuffer$append(byte[] int int ), 0, this, byArray, n, n2);
    }

    public void append(ByteArrayBuffer byteArrayBuffer, int n, int n2) {
        InvokeDynamicSupport.bootstrap("append", $$robo$$org_apache_http_util_CharArrayBuffer$append(org.apache.http.util.ByteArrayBuffer int int ), 0, this, byteArrayBuffer, n, n2);
    }

    public void append(Object object) {
        InvokeDynamicSupport.bootstrap("append", $$robo$$org_apache_http_util_CharArrayBuffer$append(java.lang.Object ), 0, this, object);
    }

    public void clear() {
        InvokeDynamicSupport.bootstrap("clear", $$robo$$org_apache_http_util_CharArrayBuffer$clear(), 0, this);
    }

    public char[] toCharArray() {
        return InvokeDynamicSupport.bootstrap("toCharArray", $$robo$$org_apache_http_util_CharArrayBuffer$toCharArray(), 0, this);
    }

    public char charAt(int n) {
        return (char)InvokeDynamicSupport.bootstrap("charAt", $$robo$$org_apache_http_util_CharArrayBuffer$charAt(int ), 0, this, n);
    }

    public char[] buffer() {
        return InvokeDynamicSupport.bootstrap("buffer", $$robo$$org_apache_http_util_CharArrayBuffer$buffer(), 0, this);
    }

    public int capacity() {
        return (int)InvokeDynamicSupport.bootstrap("capacity", $$robo$$org_apache_http_util_CharArrayBuffer$capacity(), 0, this);
    }

    public int length() {
        return (int)InvokeDynamicSupport.bootstrap("length", $$robo$$org_apache_http_util_CharArrayBuffer$length(), 0, this);
    }

    public void ensureCapacity(int n) {
        InvokeDynamicSupport.bootstrap("ensureCapacity", $$robo$$org_apache_http_util_CharArrayBuffer$ensureCapacity(int ), 0, this, n);
    }

    public void setLength(int n) {
        InvokeDynamicSupport.bootstrap("setLength", $$robo$$org_apache_http_util_CharArrayBuffer$setLength(int ), 0, this, n);
    }

    public boolean isEmpty() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEmpty", $$robo$$org_apache_http_util_CharArrayBuffer$isEmpty(), 0, this);
    }

    public boolean isFull() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFull", $$robo$$org_apache_http_util_CharArrayBuffer$isFull(), 0, this);
    }

    public int indexOf(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrap("indexOf", $$robo$$org_apache_http_util_CharArrayBuffer$indexOf(int int int ), 0, this, n, n2, n3);
    }

    public int indexOf(int n) {
        return (int)InvokeDynamicSupport.bootstrap("indexOf", $$robo$$org_apache_http_util_CharArrayBuffer$indexOf(int ), 0, this, n);
    }

    public String substring(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("substring", $$robo$$org_apache_http_util_CharArrayBuffer$substring(int int ), 0, this, n, n2);
    }

    public String substringTrimmed(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("substringTrimmed", $$robo$$org_apache_http_util_CharArrayBuffer$substringTrimmed(int int ), 0, this, n, n2);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$org_apache_http_util_CharArrayBuffer$toString(), 0, this);
    }

    public /* synthetic */ CharArrayBuffer() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CharArrayBuffer)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

