/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.util;

import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.ParseException;
import org.apache.http.util.ByteArrayBuffer;
import org.apache.http.util.CharArrayBuffer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class EntityUtils
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;

    private void $$robo$$org_apache_http_util_EntityUtils$__constructor__() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final byte[] $$robo$$org_apache_http_util_EntityUtils$toByteArray(HttpEntity entity) throws IOException {
        if (entity == null) {
            throw new IllegalArgumentException("HTTP entity may not be null");
        }
        InputStream instream = entity.getContent();
        if (instream == null) {
            return new byte[0];
        }
        if (entity.getContentLength() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("HTTP entity too large to be buffered in memory");
        }
        int i = (int)entity.getContentLength();
        if (i < 0) {
            i = 4096;
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(i);
        try {
            int l;
            byte[] tmp = new byte[4096];
            while ((l = instream.read(tmp)) != -1) {
                buffer.append(tmp, 0, l);
            }
        }
        finally {
            instream.close();
        }
        return buffer.toByteArray();
    }

    private static final String $$robo$$org_apache_http_util_EntityUtils$getContentCharSet(HttpEntity entity) throws ParseException {
        NameValuePair param;
        HeaderElement[] values;
        if (entity == null) {
            throw new IllegalArgumentException("HTTP entity may not be null");
        }
        String charset = null;
        if (entity.getContentType() != null && (values = entity.getContentType().getElements()).length > 0 && (param = values[0].getParameterByName("charset")) != null) {
            charset = param.getValue();
        }
        return charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String $$robo$$org_apache_http_util_EntityUtils$toString(HttpEntity entity, String defaultCharset) throws IOException, ParseException {
        String charset;
        if (entity == null) {
            throw new IllegalArgumentException("HTTP entity may not be null");
        }
        InputStream instream = entity.getContent();
        if (instream == null) {
            return "";
        }
        if (entity.getContentLength() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("HTTP entity too large to be buffered in memory");
        }
        int i = (int)entity.getContentLength();
        if (i < 0) {
            i = 4096;
        }
        if ((charset = EntityUtils.getContentCharSet(entity)) == null) {
            charset = defaultCharset;
        }
        if (charset == null) {
            charset = "ISO-8859-1";
        }
        CharArrayBuffer buffer = new CharArrayBuffer(i);
        try (InputStreamReader reader = new InputStreamReader(instream, charset);){
            int l;
            char[] tmp = new char[1024];
            while ((l = reader.read(tmp)) != -1) {
                buffer.append(tmp, 0, l);
            }
        }
        return buffer.toString();
    }

    private static final String $$robo$$org_apache_http_util_EntityUtils$toString(HttpEntity entity) throws IOException, ParseException {
        return EntityUtils.toString(entity, null);
    }

    private void __constructor__() {
        this.$$robo$$org_apache_http_util_EntityUtils$__constructor__();
    }

    private EntityUtils() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_util_EntityUtils$__constructor__(), 0, this);
    }

    public static byte[] toByteArray(HttpEntity httpEntity) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("toByteArray", $$robo$$org_apache_http_util_EntityUtils$toByteArray(org.apache.http.HttpEntity ), 0, (HttpEntity)httpEntity);
    }

    public static String getContentCharSet(HttpEntity httpEntity) throws ParseException {
        return InvokeDynamicSupport.bootstrapStatic("getContentCharSet", $$robo$$org_apache_http_util_EntityUtils$getContentCharSet(org.apache.http.HttpEntity ), 0, (HttpEntity)httpEntity);
    }

    public static String toString(HttpEntity httpEntity, String string2) throws IOException, ParseException {
        return InvokeDynamicSupport.bootstrapStatic("toString", $$robo$$org_apache_http_util_EntityUtils$toString(org.apache.http.HttpEntity java.lang.String ), 0, (HttpEntity)httpEntity, (String)string2);
    }

    public static String toString(HttpEntity httpEntity) throws IOException, ParseException {
        return InvokeDynamicSupport.bootstrapStatic("toString", $$robo$$org_apache_http_util_EntityUtils$toString(org.apache.http.HttpEntity ), 0, (HttpEntity)httpEntity);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EntityUtils)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

